package mainClasses;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

import commands.AICommand;
import commands.IAICommand;

public class GAStatistic {

	private GAPopulation population = null;
	
	private static int notValidMax = 2000000000;
	
	private static int notValidMin = -1;
	
	private boolean firstRunDone = false;
	
	private boolean secondRunDone = false;
	
	private boolean medianRunDone = false;

	private int ratedProgramCount = notValidMin;
	
	private int runningProgramCount = notValidMin;
	
	private int maxPoints = notValidMin;
	
	private int minPoints = notValidMax;
	
	private double averagePoints = notValidMin;
	
	private double standardDeviationPoints = notValidMin;
	
	private int maxProgramDepth = notValidMax;
	
	private int minProgramDepth = notValidMin;
	
	private List<Integer> medianArray = null;
	
	public class PointRangeItem {
		public int start = 0;
		public int end = 0;
		public int count = 0;
		public int sum = 0;
	}

	private List<PointRangeItem> prArray = null;

	public class PointRangeComparator implements Comparator<PointRangeItem> {

		@Override
		public int compare(PointRangeItem arg0, PointRangeItem arg1) {
			if (arg0.start < arg1.start) {
				return -1;
			} else if (arg0.start > arg1.start) {
				return 1;
			} else {
				return 0;
			}
		}
		
	}

	public GAStatistic(GAPopulation population) {
		setPopulation(population);
	}
	
	public void setPopulation(GAPopulation population) {
		this.population = population;
		firstRunDone = false;
		secondRunDone = false;
		medianRunDone = false;
	}
	
	public int getGeneration() {
		if (this.population != null) {
			return this.population.getGeneration() + 1;
		} else {
			return notValidMin;
		}
	}

	public int getPopulationSize() {
		if (this.population != null) {
			return this.population.getSize();
		} else {
			return notValidMin;
		}
	}
	
	public int getRatedProgramCount() {
		firstRun();
		return this.ratedProgramCount;
	}
	
	public int getRunningProgramCount() {
		firstRun();
		return this.runningProgramCount;
	}
	
	public int getMaxPoints() {
		firstRun();
		return this.maxPoints;
	}
	
	public int getMinPoints() {
		firstRun();
		return this.minPoints;
	}
	
	public int getMaxRating() {
		return population.getMaxRating();
	}
	
	public double getAveragePoints() {
		firstRun();
		return this.averagePoints;
	}
	
	public double getStandardDeviation() {
		secondRun(); // include first run
		return this.standardDeviationPoints;
	}
	
	public double getPercentDone() {
		firstRun();
		if (this.population.getSize() > 0) {
			return ((double)this.ratedProgramCount / this.population.getSize());
		} else {
			return notValidMin;
		}
	}
	
	public int getCurrentStartedProgramCount() {
		firstRun();
		return this.runningProgramCount;
	}
	
	public int getMinProgramDepth() {
		firstRun();
		return this.minProgramDepth;
	}
	
	public int getMaxProgramDepth() {
		firstRun();
		return this.maxProgramDepth;
	}

	public int getMedian(int pos) {
		medianRun();
		int mid = this.medianArray.size() / 2;
		int ret = notValidMin;
		
		if (mid >= this.medianArray.size()) {
			return -1;
		}

		if ((this.medianArray.size() % 2) == 0) {
			// gerade
			if (pos >= 0) {
				ret = this.medianArray.get(mid + pos);
			} else {
				ret = this.medianArray.get(mid + 1 + pos); // pos is negative!
			}
		} else {
			// ungerade
			if (pos >= 0) {
				ret = this.medianArray.get(mid + pos);
			} else {
				ret = this.medianArray.get(mid + 2 + pos); // pos is negative!
			}
		}
		return ret;
	}
	
	public int getMedian() {
		return (getMedian(+1) + getMedian(-1)) / 2;
	}
	
	public int getMedian(float procent) {
		medianRun();
		int pos = (int)(procent * this.medianArray.size());
		if ((pos >=0) && (pos < this.medianArray.size())) {
			return this.medianArray.get(pos);
		} else {
			return notValidMin;
		}
	}
	
	public int getAverage(float from, float to) {
		int posFrom = (int)(from * this.medianArray.size());
		int posTo = (int)(to * this.medianArray.size());
		if (posFrom < 0) posFrom = 0;
		if (posTo >= this.medianArray.size()) posTo = this.medianArray.size()-1;
		if ((posFrom >=0) && (posTo >= 0)) {
			if ((posFrom < this.medianArray.size()) && (posTo < this.medianArray.size())) {
				if (posFrom <= posTo) {
					int sum = 0;
					for (int i=posFrom; i<posTo; i++) {
						sum = sum + this.medianArray.get(i);
					}
					return sum / (posTo - posFrom + 1);
				} else {
					return notValidMin;
				}
			} else {
				return notValidMin;
			}
		} else {
			return notValidMin;
		}
	}
	
	public int getPointRangeCount() {
		return this.prArray.size();
	}
	
	public PointRangeItem getPointRangeItem(int i) {
		return this.prArray.get(i);
	}
	
	public int getSinglePointSum() {
		int sum = 0;
		for (int i=0; i<this.prArray.size(); i++) {
			sum = sum + this.prArray.get(i).sum;
		}
		return sum;
	}
	
	private void firstRun() {
		if (this.firstRunDone == false) {
			this.ratedProgramCount = 0;
			this.runningProgramCount = 0;
			this.maxPoints = notValidMin;
			this.minPoints = notValidMax;
			this.averagePoints = notValidMin;
			this.minProgramDepth = notValidMax;
			this.maxProgramDepth = notValidMin;
			this.medianArray = new ArrayList<Integer>();
			this.prArray = new ArrayList<PointRangeItem>();
			int sumPoints = 0;
			for (int i=0; i<this.population.getSize(); i++) {
				int currRating = this.population.get(i).getRating(); 
				boolean foundSItem = false;
				if (currRating > notValidMin) {
					this.ratedProgramCount++;
					sumPoints = sumPoints + currRating;
					if (this.maxPoints < currRating) {
						this.maxPoints = currRating;
					}
					if (this.minPoints > currRating) {
						this.minPoints = currRating;
					}
					this.medianArray.add(new Integer(currRating));
					for (int j=0; j<this.prArray.size(); j++) {
						if ((this.prArray.get(j).start <= currRating) && 
								(this.prArray.get(j).end >= currRating)) {
							this.prArray.get(j).count++;
							this.prArray.get(j).sum = this.prArray.get(j).sum + currRating;
							foundSItem = true;
							break;
						}
					}
					if (!foundSItem) {
						PointRangeItem newItem = new PointRangeItem();
						int start = (currRating / 200);
						newItem.start = start * 200;
						newItem.end = newItem.start + 199;
						newItem.count = 1;
						newItem.sum = currRating;
						this.prArray.add(newItem);
					}
				}
				if (this.population.get(i).isStarted()) {
					this.runningProgramCount++;
				}
				GAPopulation pop = this.population;
				GAProgram prog = pop.get(i);
				IAICommand com = prog.getProgram();
				if (com != null) {
					int cur_depth = ((AICommand)com).getProgramDepth();
					if (this.minProgramDepth > cur_depth) {
						this.minProgramDepth = cur_depth;
					}
					if (this.maxProgramDepth < cur_depth) {
						this.maxProgramDepth = cur_depth;
					}
				}
			}
			this.averagePoints = ((double) sumPoints) / this.ratedProgramCount;
			Collections.sort(this.prArray,new PointRangeComparator());
		}
		this.firstRunDone = true;
	}
	
	private void secondRun() {
		firstRun();
		if (this.secondRunDone == false) {
			this.standardDeviationPoints = notValidMin;
			if (this.ratedProgramCount > 1) {
				double sum_deviation = 0;
				for (int i=0; i<population.getSize(); i++) {
					int currRating = this.population.get(i).getRating(); 
					if (currRating > -1) {
						double tmp = ( (double)currRating ) - this.averagePoints;
						sum_deviation = sum_deviation + tmp * tmp;
					}
				}
				this.standardDeviationPoints = Math.sqrt(sum_deviation / (this.ratedProgramCount - 1));
			}
		}
		this.secondRunDone = true;
	}

	public void medianRun() {
		firstRun();
		if (this.medianRunDone == false) {
			Collections.sort(this.medianArray);
		}
		this.medianRunDone = true;
	}
	
	public String getVText(int value, String unit, int notValid, String notValidText) {
		if (value != notValid)  {
			return value + unit;
		} else {
			return notValidText;
		}
	}
	
	public String getVText(double value, String unit, int notValid, String notValidText) {
		if (value != notValid)  {
			return value + unit;
		} else {
			return notValidText;
		}
	}

	public String getText(String desc, int value, String unit, int notValid, String notValidText) {
		return desc + " = " + getVText(value, unit, notValid, notValidText) + "\n";
	}
}
