package mainClasses;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.net.Socket;
import java.net.UnknownHostException;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ServerController extends Thread {

	public enum Status {
		DOWN, AUTOMATIC, MANUAL, STARTONE
	}
	
	private String servername = "";
	
	private int serverport = 0;
	
	private boolean shutdown = false;
	
	private ExecutionManager manager = null;
	
	private String serverStatus = "";

	private OutputStream out = null;
	
	private Status status = Status.DOWN;
	
	private final int waitingTimeBetweenStatusCall = 10000;
	
	private GAProgram program = null;
	
	private int showNoProgramInfo = 0;
	
	private boolean currentConfigurating = false; 
	
	private boolean showSendInitializeMessage = true;
	
	public ServerController() {
	}
	
	public String setServername(String newServerName) {
		servername = newServerName;
		this.setName("ServerController: " + servername + ":" + serverport);
		return servername;
	}
	
	public int setServerPort(int newPort) {
		serverport = newPort;
		this.setName("ServerController: " + servername + ":" + serverport);
		return serverport;
	}
	
	public ExecutionManager setExecutionManager(ExecutionManager manager) {
		this.manager = manager;
		return this.manager;
	}
	
	private class Listener extends Thread {

		private ServerController ctrl = null;
		private Socket socket = null;
		private boolean shutdown = false;
		
		public Listener(ServerController controller, Socket socket) {
			this.ctrl = controller;
			this.socket = socket;
			this.setName("ServerController.Listener: " + servername + ":" + serverport);
		}
		
		@Override
		public void run() {
			InputStream in = null;
			try {
				in = socket.getInputStream();
			} catch (IOException e) {
				return;
			}
			String input = "";
			while (!shutdown) {
				try {
					input = input + (char)(in.read());
				} catch (IOException e) {
					break;
				}
				if (input.indexOf("<!--ende-->") > -1) {
					ctrl.input(input);
					input = "";
				}
			}
		}
		
	}
	
	@Override
	public void run() {
		if (manager == null) {
			return;
		}
		
		if (out != null) {
			return;
		}
		
		Listener listener = null;
		int tries = 0;
		while (!shutdown) {
			boolean exceptionOccur = false;
			Socket socket = null;
			listener = null;
			try {
				socket = new Socket( servername, serverport );
				if (socket != null) {
					out = socket.getOutputStream();
					listener = new Listener(this, socket);
					listener.start();
					status = Status.MANUAL;
	
					while (!shutdown) {
						sendStatus();
						if (!socket.isConnected()) {
							break;
						}
						if (!listener.isAlive()) {
							System.out.println("ServerController:run(): Listener died");
							break;
						}
						sleep(waitingTimeBetweenStatusCall);
					}
				}
			} catch (UnknownHostException e) {
				exceptionOccur = true;
			} catch (IOException e) {
				exceptionOccur = true;
			} catch (InterruptedException e) {
				exceptionOccur = true;
			} catch (Exception e) {
				exceptionOccur = true;
			} finally {
				status = Status.DOWN;
				if (listener != null) {
					listener.shutdown = true;
				}
				serverStatus = "Connection closed!";
			}
			if (socket != null) {
				try {
					socket.close();
				} catch (NullPointerException e1) {
				} catch (IOException e1) {
				}
			}
			if (exceptionOccur) {
				tries++;
				if (tries > 10) {
					if (program != null) {
						program.setFinished();
					}
					program = null;
				}
				try {
					sleep(5000);
				} catch (InterruptedException e) {
				}
			}
		}
	}

	public void input(String input) {
		if (this.program != null) {
			Date d = new Date();
			program.setTimeout(d.getTime() + 180000);
		}
		DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance(); 
		DocumentBuilder builder = null;
		try {
			builder = factory.newDocumentBuilder();
			Document document = builder.parse(new InputSource(new StringReader(input)));
			interpret(document);
		} catch (ParserConfigurationException e) {
			System.out.println("ServerController.input(): ERROR: " + e.getMessage());
		} catch (SAXException e) {
			System.out.println("ServerController.input(): ERROR: " + e.getMessage());
		} catch (IOException e) {
			System.out.println("ServerController.input(): ERROR: " + e.getMessage());
		} 
	}

	private void interpret(Document document) {
		Node rootNode = document.getFirstChild();
		String rootString = rootNode.getNodeName();
		//System.out.println("ServerController.interpret(): " + root);
		if (rootString.equals("status")) {
			serverStatus = ((Element)rootNode).getAttribute("text");
			Node subNode = rootNode.getFirstChild();
			int rating = -1;
			String identifier = "";
			while (subNode != null) {
				if (subNode.getNodeName().equals("rating")) {
					rating = Integer.valueOf(subNode.getTextContent());
					identifier = ((Element)subNode).getAttribute("identifier");
				}
				subNode = subNode.getNextSibling();
			}
			if (serverStatus.equals("FINISHED")) {
				if ((currentConfigurating == false) && (showSendInitializeMessage)) {
					showSendInitializeMessage = false;
					Date d = new Date();
					DateFormat df = DateFormat.getTimeInstance( DateFormat.MEDIUM, Locale.GERMANY );
					System.out.println(df.format(d) + " ServerController.interpret(" + this.servername + ":" + this.serverport + ")");
					manager.setRatingFinished(identifier, rating);
				}
			}
			if ((status == Status.AUTOMATIC) || (status == Status.STARTONE)) {
				if (currentConfigurating == false) {
					currentConfigurating = true;
					try {
						if (serverStatus.equals("JUSTBEGIN")) {
							sendCreate();
						} else if (serverStatus.equals("CREATED")) {
							sendInitialize();
						} else if (serverStatus.equals("INITIALIZED")) {
							sendStart();
							if (status == Status.STARTONE) {
								status = Status.MANUAL;
							}
						} else if (serverStatus.equals("FINISHED")) {
							sendCreate();
						}
					} catch (Exception e) {
						currentConfigurating = false;
					}
					currentConfigurating = false;
					showSendInitializeMessage = true;
				}
			}
			String toAdd = document.getFirstChild().getTextContent();
			if (!toAdd.isEmpty()) {
				serverStatus = serverStatus + " -> " + toAdd;
			}
		}
	}

	public String getServerName() {
		return servername;
	}
	
	public int getServerPort() {
		return serverport;
	}

	public void sendShutdown() {
		sendCmd("<shutdown manager=\"" + this.manager.getIdentifier() +"\"/>");
	}
	
	public void sendCreate() {
		sendCmd("<create manager=\"" + this.manager.getIdentifier() +"\"/>");
	}
	
	public void sendInitialize() {
		Date d = new Date();
		DateFormat df = DateFormat.getTimeInstance( DateFormat.MEDIUM, Locale.GERMANY );

		if (manager == null) {
			System.out.println(df.format(d) + " ServerController.sendInitialize(): ERROR: No Manager");
			return;
		}
		System.out.println(df.format(d) + " ServerController.sendInitialize(" + this.servername + ":" + this.serverport + "): ");
		program = manager.getNextProgram(program);
		if (program == null) {
			if (showNoProgramInfo == 0) {
				System.out.println(df.format(d) + " ServerController.sendInitialize(): ERROR: No Program");
			}
			showNoProgramInfo = (showNoProgramInfo+1) % 100000;
			return;
		} else {
			showNoProgramInfo = 0;
		}
		String ret = program.getProgramString();
		sendCmd("<initialise manager=\"" + this.manager.getIdentifier() +"\" identifier=\"" + program.getIdentifier() + 
				"\"><code>" + ret + "</code></initialise>");
	}
	
	public void sendStart() {
		sendCmd("<start manager=\"" + this.manager.getIdentifier() +"\"/>");
	}

	public void sendStop() {
		sendCmd("<stop manager=\"" + this.manager.getIdentifier() +"\"/>");
	}
	
	public void sendStatus() {
		sendCmd("<status manager=\"" + this.manager.getIdentifier() +"\"/>");
	}
	
	public void sendSetting(String servername) {
		sendCmd("<setting manager=\"" + this.manager.getIdentifier() +"\" servername=\"" + servername + "\"/>");
	}
	
	public void sendCmd(String send) {
		if (out != null) {
			try {
				out.write((send + "<!--ende-->").getBytes());
			} catch (IOException e) {
			}
		}
	}
	
	public String getServerStatus() {
		return serverStatus;
	}
	
	public void doShutdown() {
		shutdown = true;
	}
	
	public void activateAutomaticMode() {
		status = Status.AUTOMATIC;
	}
	
	public void activateManualMode() {
		status = Status.MANUAL;
	}
	
	public Status getStatus() {
		return status;
	}

	public void activateStartOneMode() {
		status = Status.STARTONE;
	}
}
