package mainClassesTests;

import java.util.Random;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import mainClasses.GAGenerationGenerator;
import mainClasses.GAPopulation;
import mainClasses.GAProgram;
import mainClasses.GAProgramGenerator;

import commands.AddCommand;
import commands.DivCommand;
import commands.NumberCommand;

public class GAGenerationGeneratorTest extends TestCase {

	private GAGenerationGenerator generator = null;
	
	protected void setUp() throws Exception {
		super.setUp();
		generator = new GAGenerationGenerator();
	}

	protected void tearDown() throws Exception {
		super.tearDown();
	}

	public void testGenerateGAPopulationInt() {
		GAPopulation gap = new GAPopulation();
		GAProgramGenerator pg = new GAProgramGenerator();
		
		pg.addCommand(new AddCommand());
		pg.addCommand(new DivCommand());
		NumberCommand numberCommand = new NumberCommand();
		numberCommand.setNumber(123456);
		pg.addCommand(numberCommand);
		pg.setFill(true);
		pg.setMaxDepth(3);

		Random random = new Random(0);
		pg.setRandom(random);
		generator.generate(gap, pg, 10);
		
		GAProgram p = null;
		p = gap.get(0);
		assertEquals("DIV DIV ADD 27483 -76599 DIV -49445 96968 DIV ADD -64805 -74221 ADD -95353 -98156", p.getProgramString());
		p = gap.get(1);
		assertEquals("DIV ADD ADD -42820 55262 DIV -2554 96189 DIV DIV 67778 45154 DIV 9225 95714", p.getProgramString());
		p = gap.get(2);
		assertEquals("DIV DIV DIV -71356 -45151 DIV 37900 -32247 DIV DIV 48891 22516 ADD -56486 -83443", p.getProgramString());
		p = gap.get(3);
		assertEquals("ADD DIV ADD 89636 -57753 DIV 89066 23701 DIV DIV 57208 -36741 ADD -71251 44859", p.getProgramString());
		p = gap.get(4);
		assertEquals("DIV ADD DIV -11715 -80773 ADD 42583 93853 ADD ADD 57544 -94179 ADD 94390 -30032", p.getProgramString());
		p = gap.get(5);
		assertEquals("DIV DIV DIV -32499 69656 ADD -97965 64035 DIV DIV -99265 42662 ADD -37510 74852", p.getProgramString());
		p = gap.get(6);
		assertEquals("DIV DIV DIV -91102 -35927 ADD -1724 -26728 ADD DIV -56809 -97670 DIV 49070 -3683", p.getProgramString());
		p = gap.get(7);
		assertEquals("DIV ADD ADD -32956 -99218 ADD 78563 -55878 ADD DIV -18301 -66001 ADD 69450 15991", p.getProgramString());
		p = gap.get(8);
		assertEquals("DIV ADD ADD 8045 -95989 ADD 75593 26057 DIV DIV -36245 -37022 DIV -61957 85467", p.getProgramString());
		p = gap.get(9);
		assertEquals("ADD DIV DIV 17804 -64205 ADD 36788 63682 ADD DIV 6829 24179 DIV -60989 -81771", p.getProgramString());
	}

	public static final Test suite() {
		TestSuite suite = new TestSuite();
		suite.setName("GAGenerationGenerator");
		suite.addTestSuite(GAGenerationGeneratorTest.class);
		return suite;
	}
}
