package mainClassesTests;

import java.util.Random;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import mainClasses.GAProgram;
import mainClasses.GAProgramGenerator;

import commands.AddCommand;
import commands.DivCommand;
import commands.NumberCommand;

public class GAProgramGeneratorTest extends TestCase {

	private GAProgramGenerator gaProgramGenerator = null;
	
	protected void setUp() throws Exception {
		super.setUp();
		gaProgramGenerator = new GAProgramGenerator();
	}

	protected void tearDown() throws Exception {
		super.tearDown();
	}

	public void testGenerateGAProgram() {
		Random random = new Random(0);
		gaProgramGenerator.setRandom(random);
		gaProgramGenerator.addCommand(new AddCommand());
		gaProgramGenerator.addCommand(new DivCommand());
		NumberCommand numberCommand = new NumberCommand();
		numberCommand.setNumber(123456);
		gaProgramGenerator.addCommand(numberCommand);
		GAProgram program = new GAProgram();
		gaProgramGenerator.generate(program, 3, true);
		assertEquals("DIV DIV ADD 27483 -76599 DIV -49445 96968 DIV ADD -64805 -74221 ADD -95353 -98156", program.getProgramString());
	}

	public static final Test suite() {
		TestSuite suite = new TestSuite();
		suite.setName("GAProgramGenerator");
		suite.addTestSuite(GAProgramGeneratorTest.class);
		return suite;
	}
}
