package simulation;

import java.util.ArrayList;
import java.util.List;

public class Memory {

	protected int size = 0;
	protected List<Integer> memory = null;
	
	public Memory() {
		size = 0;
		initialise();
	}
	
	public void initialise() {
		memory = new ArrayList<Integer>();
		for (int i=0; i<size; i++) {
			memory.add(new Integer(0));
		}
	}
	
	public int setSize(int newSize) {
		size = newSize;
		initialise();
		return size;
	}
	
	public int getSize() {
		return size;
	}
	
	public int getValue(int pos) {
		pos = pos % size;
		if (pos < size) {
			return memory.get(pos);
		}
		return 0;
	}
	
	public int setValue(int pos, int value) {
		pos = pos % size;
		if (pos < size) {
			memory.set(pos, new Integer(value));
			return value;
		}
		return 0;
	}
}
