package simulation;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;

public class PeerToPeerConnection extends Thread {

	private Socket client = null;
	private InputStream in = null; 
	private OutputStream out = null; 
	private SocketCommunication server = null;
	private boolean shutdown = false;
	
	public PeerToPeerConnection(Socket newClient, SocketCommunication server) {
		this.setName("PeerToPeerConnection");
		this.client = newClient;
		this.server = server;
		try {
			in = client.getInputStream();
			out = client.getOutputStream(); 
		} catch (IOException e) {
		} 
	}
	
	public void send(String toSendText) {
		try {
			out.write( toSendText.getBytes() );
		} catch (IOException e) {
		}		
	}
	
	@Override
	public void run() {
		String input = "";
		int tries = 0;
		while (!shutdown) {
			try {
				input = input + (char)(in.read());
				tries = 0;
			} catch (IOException e) {
				tries++;
				if (tries > 3) {
					break;
				}
				try {
					sleep(10);
				} catch (InterruptedException e1) {
				}
			}
			if (input.indexOf("<!--ende-->") > -1) {
				server.input(input);
				input = "";
			}
		}
		this.close();
	}

	public void close() {
		if ( client != null ) {
			try { 
				client.close();
				server.removeClient(this);
			} catch ( IOException e ) { 
			} 
			client = null;
		} 	
	}

	public void doShutdown() {
		shutdown = true;
		close();
	}
	
}
