package simulation;

import java.io.IOException;
import java.util.concurrent.Semaphore;

import commands.KeyCommand.Type;

import extern.FramePacket;
import extern.KeysPacket;
import extern.ServerConnection;

public class SimulationCommunicator implements ICommunicationToSimulation {

	public ServerConnection serverConnection = null;
	private KeysPacket keysPacket = null;
	private Semaphore sendKeySemaphore = null;

	public SimulationCommunicator() {
		keysPacket = new KeysPacket();
		sendKeySemaphore = new Semaphore(1);
	}

	@Override 
	public void sendGameKeys(int key, Type type) {
		key = key % 5;
		sendKey(key, type);
	}
	
	@Override
	public void sendKey(int key, Type type) {
		// TODO Test missing

		try {
			sendKeySemaphore.acquire();
		} catch (InterruptedException e1) {
			return;
		}
		
		key = key % 6;
		
		switch (key) {
		case 0: keysPacket.left(type == Type.PRESS ? true : false); break;
		case 1: keysPacket.right(type == Type.PRESS ? true : false); break;
		case 2: keysPacket.thrust(type == Type.PRESS ? true : false); break;
		case 3: keysPacket.fire(type == Type.PRESS ? true : false); break;
		case 4: keysPacket.hyperspace(type == Type.PRESS ? true : false); break;
		case 5: keysPacket.start(type == Type.PRESS ? true : false); break;
		}
		
		try {
			if (serverConnection != null) {
				serverConnection.send(keysPacket);
			}
		} catch (IOException e) {
		}
				
		try {
			Thread.sleep(1);
		} catch (InterruptedException e) {
		}
		sendKeySemaphore.release();
	}

	@Override
	public void resetKeys() {
		try {
			sendKeySemaphore.acquire();
		} catch (InterruptedException e1) {
			return;
		}
		keysPacket.reset();
		try {
			if (serverConnection != null) {
				serverConnection.send(keysPacket);
			}
		} catch (IOException e) {
		}		
		sendKeySemaphore.release();
	}

	@Override
	public void getFrame(FramePacket framePacket) {
		if (serverConnection != null) {
			try {
				serverConnection.receive(framePacket);
			} catch (IOException e) {
			}
		}		
	}

	@Override
	public void stop() {
		if (serverConnection != null) {
			serverConnection.stop();
		}
	}

	@Override
	public void setServername(String servername) {
		serverConnection.setServername(servername);
	}

}
