package simulation;

import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;

import global.Logger;

import commands.AICommand;
import commands.IAICommand;
import commands.KeyCommand.Type;

public class SimulationExecutor extends Thread {

	public enum ExecutorStatus {
		UNKNOWN, STARTING, RUNNING, FINISHED
	}
	
	private Memory memory = null;
	
	private Logger logger = null;
	
	private SimulationDisplay display = null;
	
	private ICommunicationToSimulation communicator = null;
	
	private IAICommand commandTree = null;
	
	private ExecutorStatus status = ExecutorStatus.UNKNOWN;
	
	public boolean shutdown = false;
	
	public SimulationExecutor() {
		this.setName("SimulationExecutor");
	}
	
	public void setCommandTree(IAICommand cmd) {
		commandTree = cmd;
	}
	
	public IAICommand getCommandTree() {
		return commandTree;
	}

	public void setDisplay(SimulationDisplay newDisplay) {
		display = newDisplay;
	}

	private class GameFinishedListener extends Thread {
		
		public boolean stop = false;
		
		public GameFinishedListener() {
			this.setName("GameFinishedListener");
		}
		
		@Override
		public void run() {
			while (!stop) {
				if (isReallyFinished()) {
					((AICommand)commandTree).stopExec();
					Date d = new Date();
					DateFormat df = DateFormat.getTimeInstance( DateFormat.MEDIUM, Locale.GERMANY ); 
					System.out.println(df.format(d) + " GameFinishedListener.run(): Game end detected");
					break;
				}
				try {
					sleep(100);
				} catch (InterruptedException e) {
				}
			}
		}
		
	}

	@Override
	public void run() {
		status = ExecutorStatus.STARTING;
		boolean started = false;
		shutdown = false;
		//System.out.println("SimulationExecutor.run(): initialize");
		initialize();
		GameFinishedListener gfl = new GameFinishedListener();
		while ((!isInterrupted()) && (!shutdown)) { 
			//System.out.print("step ");
			if (gameRunning() || started) {
				if (!started) {
					Date d = new Date();
					DateFormat df = DateFormat.getTimeInstance( DateFormat.MEDIUM, Locale.GERMANY ); 

					System.out.println(df.format(d) + " SimulationExecutor.run(): START START START START START START");
					started = true;
					status = ExecutorStatus.RUNNING;
					gfl.start();
				}
				doStep();
				try {
					sleep(1);
				} catch (InterruptedException e) {
				}
			} 
			if (!gameRunning()) {
				if (started) {
					if (isReallyFinished()) {
						((AICommand)commandTree).stopExec();
						break;
					}
				} else {
					startGame();
				}
			}
		}
		gfl.stop = true;
		status = ExecutorStatus.FINISHED;
		communicator.resetKeys();

		Date d = new Date();
		DateFormat df = DateFormat.getTimeInstance( DateFormat.MEDIUM, Locale.GERMANY ); 
		System.out.println(df.format(d) + " SimulationExecutor.run(): SimulationExeccutor.run(): stop " + display.getLastPoints());

		clear();
	}

	private boolean isReallyFinished() {
		//for (int i=0; i<100000; i++) {
			String tmp = display.getDisplayText();
			//if (display.checkPlayerShipVisible()) {
				//System.out.println("SimulationExecutor.isReallyFinished(): Game continuing");
				//return false;
			//}
			if ((tmp.indexOf("SPIELENDE") > -1) || 
					(tmp.indexOf("IHR ERGEBNIS IST EINES DER ZEHN BESTEN") > -1) ||
					(tmp.indexOf("STARTKNOEPFE DRUECKEN") > -1)) {
				Date d = new Date();
				DateFormat df = DateFormat.getTimeInstance( DateFormat.MEDIUM, Locale.GERMANY ); 
				System.out.println(df.format(d) + " SimulationExecutor.isReallyFinished(): Game end detected");
				return true;
			}
			//if ((isInterrupted()) || (shutdown)) {
			//	System.out.println("SimulationExecutor.isReallyFinished(): Execution stop detected");
			//	return true;
			//}
			//try {
			//	sleep(10);
			//} catch (InterruptedException e) {
			//}
		//}
		//System.out.println("SimulationExecutor.isReallyFinished(): Status unknown -> Game End");
		//return true;
		return false;
	}

	public void initialize() {
		initializeMemory();
		// TODO initializeDisplay();
	}
	
	public void initializeMemory() {
		memory = new Memory();
		memory.setSize(500);
	}
	
	public void doStep() {
		commandTree.doCommand();
		//System.out.println("SimulationExecutor.doStep(): " + commandTree.doCommand());
		//System.out.println("SimulationExecutor.doStep(): " + logger.getLog());
		logger.clear();
	}
	
	public void clear() {
		// TODO clear method stub
	}
	
	public void setLogger(Logger newLogger) {
		logger = newLogger;
	}
	
	public boolean gameRunning() {
		if (display != null) {
			return display.checkPlayerShipVisible();
		}
		return false;
	}
	
	public void startGame() {
		if (communicator != null) {
			// Reset Keys
			communicator.resetKeys();
			// Press Space for skipping letter input
			for (int i=0; i<3; i++) {
				skipInsertTopListMessage();
			}
			// Press Start-Button
			communicator.sendKey(5, Type.PRESS);
			communicator.sendKey(5, Type.RELEASE);
			try {
				sleep(100);
			} catch (InterruptedException e) {
			}
		} else {
			System.out.println("SimulationExecutor.startGame(): ERROR: communicator missing (SimulationExecutor)");
		}
	}

	private void skipInsertTopListMessage() {
		String tmp = display.getDisplayText();
		if (tmp.indexOf("IHR ERGEBNIS IST EINES DER ZEHN BESTEN") > -1) {
			communicator.sendKey(4, Type.PRESS);
			communicator.sendKey(4, Type.RELEASE);
		}
		try {
			sleep(100);
		} catch (InterruptedException e) {
		}

	}
	
	public void setCommunicator(ICommunicationToSimulation communicator) {
		this.communicator = communicator;
	}
	
	public ExecutorStatus getStatus() {
		return status;
	}
}
