package simulation;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;

import mainClasses.ExecutionManager;
import mainClasses.GAGenerationGenerator;
import mainClasses.GALibrary;
import mainClasses.GANextGenerationGenerator;
import mainClasses.GAPopulation;
import mainClasses.GAProgramGenerator;
import mainClasses.GASave;
import mainClasses.ServerController;

import commands.ACosCommand;
import commands.ASinCommand;
import commands.ATanCommand;
import commands.AddCommand;
import commands.AndCommand;
import commands.CosCommand;
import commands.DisplayCommand;
import commands.DivCommand;
import commands.EquCommand;
import commands.IAICommand;
import commands.ITECommand;
import commands.Key2Command;
import commands.KeyCommand;
import commands.LetCommand;
import commands.LogCommand;
import commands.MulCommand;
import commands.NotCommand;
import commands.NumberCommand;
import commands.OrCommand;
import commands.ProgCommand;
import commands.ReadCommand;
import commands.SinCommand;
import commands.SleepCommand;
import commands.SqrCommand;
import commands.SubCommand;
import commands.SumCommand;
import commands.TanCommand;
import commands.WriteCommand;

import extern.ServerConnection;
import global.CreateProgramTree;
import global.Logger;
import gui.MainWindow;

public class SimulationMain {

	private static boolean startSimulationController = true;
	
	public static List<IAICommand> createCommandList(Logger logger, 
			SimulationCommunicator simCom, Memory memory, 
			SimulationDisplay display) {
		List<IAICommand> ret = new ArrayList<IAICommand>();
		AddCommand addCommand = new AddCommand();
		addCommand.setLogger(logger);
		ret.add(addCommand);
		SubCommand subCommand = new SubCommand();
		subCommand.setLogger(logger);
		ret.add(subCommand);
		MulCommand mulCommand = new MulCommand();
		mulCommand.setLogger(logger);
		ret.add(mulCommand);
		DivCommand divCommand = new DivCommand();
		divCommand.setLogger(logger);
		ret.add(divCommand);
		SqrCommand sqrCommand = new SqrCommand();
		sqrCommand.setLogger(logger);
		ret.add(sqrCommand);
		LogCommand logCommand = new LogCommand();
		logCommand.setLogger(logger);
		ret.add(logCommand);
		AndCommand andCommand = new AndCommand();
		andCommand.setLogger(logger);
		ret.add(andCommand);
		OrCommand orCommand = new OrCommand();
		orCommand.setLogger(logger);
		ret.add(orCommand);
		NotCommand notCommand = new NotCommand();
		notCommand.setLogger(logger);
		ret.add(notCommand);
		ITECommand iteCommand = new ITECommand();
		iteCommand.setLogger(logger);
		ret.add(iteCommand);
		LetCommand letCommand = new LetCommand();
		letCommand.setLogger(logger);
		ret.add(letCommand);
		EquCommand equCommand = new EquCommand();
		equCommand.setLogger(logger);
		ret.add(equCommand);
		NumberCommand numberCommand = new NumberCommand();
		numberCommand.setLogger(logger);
		ret.add(numberCommand);
		SleepCommand sleepCommand = new SleepCommand();
		sleepCommand.setLogger(logger);
		ret.add(sleepCommand);
		Key2Command key2Command = new Key2Command();
		key2Command.setLogger(logger);
		key2Command.setCommunication(simCom);
		ret.add(key2Command);
		KeyCommand keyCommand = new KeyCommand();
		keyCommand.setLogger(logger);
		keyCommand.setCommunication(simCom);
		ret.add(keyCommand);
		ReadCommand readCommand = new ReadCommand();
		readCommand.setLogger(logger);
		readCommand.setMemory(memory);
		ret.add(readCommand);
		WriteCommand writeCommand = new WriteCommand();
		writeCommand.setLogger(logger);
		writeCommand.setMemory(memory);
		ret.add(writeCommand);
		DisplayCommand displayCommand = new DisplayCommand();
		displayCommand.setLogger(logger);
		displayCommand.setDisplay(display);
		ret.add(displayCommand);
		SinCommand sinCommand = new SinCommand();
		sinCommand.setLogger(logger);
		ret.add(sinCommand);
		CosCommand cosCommand = new CosCommand();
		cosCommand.setLogger(logger);
		ret.add(cosCommand);
		TanCommand tanCommand = new TanCommand();
		tanCommand.setLogger(logger);
		ret.add(tanCommand);
		ASinCommand asinCommand = new ASinCommand();
		asinCommand.setLogger(logger);
		ret.add(asinCommand);
		ACosCommand acosCommand = new ACosCommand();
		acosCommand.setLogger(logger);
		ret.add(acosCommand);
		ATanCommand atanCommand = new ATanCommand();
		atanCommand.setLogger(logger);
		ret.add(atanCommand);
		SumCommand sumCommand = new SumCommand();
		sumCommand.setLogger(logger);
		ret.add(sumCommand);
		return ret;
	}
	
	/**
	 * @param args
	 */
	public static void main(String[] args) {
		SimulationController controller = new SimulationController();
		
		//TestCommunication test = new TestCommunication();
		//controller.setCommunicator(test);
		SocketCommunication com = new SocketCommunication(10001);
		com.start();
		controller.setCommunicator(com);
		
		ServerConnection externConnection = new ServerConnection("localhost");
		SimulationCommunicator simCommunication = new SimulationCommunicator();
		simCommunication.serverConnection = externConnection;
		controller.setCommunicationToSimulation(simCommunication);
		
		Logger logger = new Logger();
		controller.setLogger(logger);
		
		Memory memory = new Memory();
		memory.setSize(500);

		SimulationDisplay display = new SimulationDisplay();

		CreateProgramTree creater = new CreateProgramTree();
		creater.setLogger(logger);
		List<IAICommand> cList = createCommandList(logger, simCommunication, 
				memory, display);
		creater.addCommands(cList);
		
		GALibrary simLibrary = new GALibrary();
		ProgCommand progCommand = new ProgCommand();
		progCommand.setLibrary(simLibrary);
		creater.addCommand(progCommand);
		
		controller.setCreater(creater);
		
		SimulationCommunicator simCom = new SimulationCommunicator();
		simCom.serverConnection = externConnection;
		display.setCommunication(simCom);
		controller.setDisplay(display);
		if (startSimulationController) {
			controller.start();
		}
		
		// TODO change

		GAProgramGenerator gapg = new GAProgramGenerator();
		Random random = new Random();
		gapg.setRandom(random);
		
		gapg.addCommands(cList);

		GALibrary conLibrary = new GALibrary();
		ProgCommand progCommand2 = new ProgCommand();
		progCommand2.setLibrary(conLibrary);
		creater.addCommand(progCommand2);

		MainWindow window = new MainWindow();
		GAPopulation population = new GAPopulation();
		window.setPopulation(population);
		GAGenerationGenerator gagg = new GAGenerationGenerator();
		window.setGenerationGenerator(gagg);
		gagg.setProgramGenerator(gapg);
		window.setCreateProgramTree(creater);

		ExecutionManager manager = new ExecutionManager();
		manager.setSaver(new GASave());
		ServerController scontroller = new ServerController();
		scontroller.setExecutionManager(manager);
		manager.addServer(scontroller);
		manager.setPopulation(population);
		window.setExecutionManager(manager);
		GANextGenerationGenerator ngg = new GANextGenerationGenerator(random, gapg);
		ngg.setCreateProgramTree(creater);
		ngg.setLibrary(conLibrary);
		manager.setNextGenerationGenerator(ngg);
		scontroller.setServername("localhost");
		scontroller.setServerPort(10001);
		scontroller.start();

		window.open();
		
		controller.doShutdown();
		manager.doShutdown();
	}

}
