package simulation;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Semaphore;

public class SocketCommunication extends Thread implements ICommunication {

	private ServerSocket serverSocket = null;
	
	private List<PeerToPeerConnection> clients = null;
	
	private Semaphore semaphoreWaitUntilInput = null;

	private Semaphore semaphoreWaitUntilExecuted = null;

	private int port = 10001;

	private boolean shutdown = false;
	
	public SocketCommunication(int port) {
		this.setName("SocketCommunication (Server): " + port);
		this.port = port;
		clients = new ArrayList<PeerToPeerConnection>();
		semaphoreWaitUntilInput = new Semaphore(1);
		semaphoreWaitUntilExecuted = new Semaphore(1);
		try {
			semaphoreWaitUntilInput.acquire();
			semaphoreWaitUntilExecuted.acquire();
		} catch (InterruptedException e) {
		}
	}
	
	private String inputString = "";
	
	@Override
	public String getNextCommand() {
		semaphoreWaitUntilExecuted.release();
		try {
			semaphoreWaitUntilInput.acquire();
			return inputString;
		} catch (InterruptedException e) {
		}
		return "";
	}

	public void input(String input) {
		try {
			semaphoreWaitUntilExecuted.acquire();
			inputString = input;
			semaphoreWaitUntilInput.release();
		} catch (InterruptedException e) {
		}
	}

	@Override
	public void sendCommand(String send) {
		for (PeerToPeerConnection pp : clients) {
			pp.send(send);
		}
	}

	@Override
	public void run() {
		try {
			serverSocket = new ServerSocket( port );
		} catch (IOException e) {
			serverSocket = null;
			doShutdown();
			return;
		}
		
		while ( !shutdown ) { 
			Socket client = null; 
			try { 
				client = serverSocket.accept(); 
				PeerToPeerConnection pp = new PeerToPeerConnection(client, this);
				clients.add(pp);
				pp.start();
			} catch ( IOException e ) {
			} catch ( Exception e) {
			}
		}
	}

	public void close(PeerToPeerConnection peerToPeerConnection) {
		peerToPeerConnection.close();
		clients.remove(peerToPeerConnection);
	}

	public void doShutdown() {
		shutdown = true;
		try {
			serverSocket.close();
		} catch (IOException e) {
		} catch (Exception e) {
		}
		while (clients.size() > 0) {
			PeerToPeerConnection tmp = clients.get(0); 
			tmp.doShutdown();
		}
		//for (PeerToPeerConnection pp : clients) {
		//	pp.doShutdown();
		//}
	}
	
	public void removeClient(PeerToPeerConnection client) {
		clients.remove(client);
	}
}
