package simulationTests;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import simulation.SimulationDisplay;

public class DisplayTest extends TestCase {

	private final int defaultSizeOfDisplay = 500;
	
	private SimulationDisplay display = null;
	
	protected void setUp() throws Exception {
		super.setUp();
		display = new SimulationDisplay();
	}

	protected void tearDown() throws Exception {
		super.tearDown();
	}

	public void testInitialise() {
		display.initialise();
		for (int i=0; i<display.getSize(); i++) {
			assertEquals(0, display.getValue(i));
		}
	}

	public void testSetSize() {
		assertEquals(defaultSizeOfDisplay, display.setSize(300));
	}

	public void testGetSize() {
		assertEquals(defaultSizeOfDisplay, display.getSize());
	}

	public void testGetValue() {
		// INFO Not yet implemented
	}

	public void testSetValue() {
		assertEquals(0, display.setValue(5, 100));
	}

	public void testSetCommunication() {
		// INFO Not yet implemented
	}

	public void testCalcMinDistance() {
		assertEquals(0,display.calcMinDistance(512, 128, 512, 895, true));
		assertEquals(1,display.calcMinDistance(512, 128, 512, 895, false));
		assertEquals(0,display.calcMinDistance(512, 895, 512, 128, true));
		assertEquals(-1,display.calcMinDistance(512, 895, 512, 128, false));
		
		assertEquals(-1,display.calcMinDistance(1023, 390, 0, 390, true));
		assertEquals(0,display.calcMinDistance(1023, 390, 0, 390, false));
		assertEquals(1,display.calcMinDistance(0, 390, 1023, 390, true));
		assertEquals(0,display.calcMinDistance(0, 390, 1023, 390, false));

		assertEquals(-1,display.calcMinDistance(1023, 128, 0, 895, true));
		assertEquals(1,display.calcMinDistance(1023, 128, 0, 895, false));
		assertEquals(1,display.calcMinDistance(0, 895, 1023, 128, true));
		assertEquals(-1,display.calcMinDistance(0, 895, 1023, 128, false));

		assertEquals(1,display.calcMinDistance(0, 128, 1023, 895, true));
		assertEquals(1,display.calcMinDistance(0, 128, 1023, 895, false));
		assertEquals(-1,display.calcMinDistance(1023, 895, 0, 128, true));
		assertEquals(-1,display.calcMinDistance(1023, 895, 0, 128, false));

		assertEquals(-30,display.calcMinDistance(500, 400, 530, 380, true));
		assertEquals(20,display.calcMinDistance(500, 400, 530, 380, false));
		assertEquals(30,display.calcMinDistance(530, 380, 500, 400, true));
		assertEquals(-20,display.calcMinDistance(530, 380, 500, 400, false));
	}
	
	public static final Test suite() {
		TestSuite suite = new TestSuite();
		suite.setName("Display");
		suite.addTestSuite(DisplayTest.class);
		return suite;
	}
}
