package simulationTests;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import simulation.Memory;

public class MemoryTest extends TestCase {

	private Memory memory = null;
	
	protected void setUp() throws Exception {
		super.setUp();
		memory = new Memory();
	}

	protected void tearDown() throws Exception {
		super.tearDown();
	}

	public void testInitialise() {
		int size = 10;
		memory.setSize(size);
		for (int i=0; i<size; i++) {
			assertEquals(0,memory.getValue(i));
		}
	}

	public void testSetGetSize() {
		int size = 10;
		assertEquals(size,memory.setSize(size));
		assertEquals(size,memory.getSize());
		for (int i=0; i<size; i++) {
			assertEquals(0,memory.getValue(i));
		}
		memory.setValue(5, 123456);
		size = 15;
		assertEquals(size,memory.setSize(size));
		assertEquals(size,memory.getSize());
		for (int i=0; i<size; i++) {
			assertEquals(0,memory.getValue(i));
		}
	}

	public void testSetGetValue() {
		int size = 10;
		memory.setSize(size);
		for (int i=0; i<size; i++) {
			assertEquals(size-i,memory.setValue(i, size-i));
		}
		for (int i=0, j=0; i<size*2; i++, j++) {
			if (j >= size) {
				j = 0;
			}
			assertEquals(size-j,memory.getValue(i));
		}
	}

	public static final Test suite() {
		TestSuite suite = new TestSuite();
		suite.setName("Memory");
		suite.addTestSuite(MemoryTest.class);
		return suite;
	}
}
