package de.heise.anniversary.contest;

/**
 * The <code>Asteroid</code> class represents an asteroid.
 * <p>
 * An asteroid has a position, a type and a size.
 * @see GameStatus
 */
public class Asteroid extends Position {
	/**
	 * The <code>Type</code> enumeration represents the size of the asteroid.
	 * <p>
	 * There are four different shapes.
	 */
	public enum Type {
		TYPE_1, TYPE_2, TYPE_3, TYPE_4
	}

	/**
	 * The <code>Size</code> enumeration represents the size of an asteroid.
	 * <p>
	 * There are three different sizes.
	 */
	public enum Size {
		/**
		 * This defines a <code>BIG</code> asteroid; radius about 40
		 */
		BIG() {
			public int getRadius() { return 40;}
		},
		/**
		 * This defines a <code>MIDDLE</code> asteroid; radius about 20
		 */
		MIDDLE() {
			public int getRadius() { return 20;}
		},
		/**
		 * This defines a <code>SMALL</code> asteroid; radius about 8
		 */
		SMALL() {
			public int getRadius() { return 8;}
		};
		/**
		 * Returns the radius of this asteroid.
		 *
		 * @return the radius of the asteroid (nearest estimate)
		 */
		abstract public int getRadius();
	}

	private Type type;
	private Size size;

	/**
	 * Initializes a new asteroid with given position, type and size.
	 *
	 * @param x
	 *        x-coordinate
	 *
	 * @param y
	 *        y-coordinate
	 *
	 * @param type
	 *        the asteroid type
	 *
	 * @param size
	 *        the asteroid size
	 */
	public Asteroid(int x, int y, Type type, Size size) {
		super(x, y);
		this.type = type;
		this.size = size;
	}

	/**
	 * Returns the asteroids type.
	 *
	 * @return the type
	 */
	public Type getType() {
		return type;
	}

	/**
	 * Sets the asteroids type.
	 *
	 * @param type
	 * 			the type
	 */
	public void setType(Type type) {
		this.type = type;
	}

	/**
	 * Returns the asteroids size.
	 *
	 * @return the size
	 */
	public Size getSize() {
		return size;
	}

	/**
	 * Sets the asteroids size.
	 *
	 * @param size
	 * 			the size
	 */
	public void setSize(Size size) {
		this.size = size;
	}
}
