package de.heise.anniversary.contest;

import java.net.UnknownHostException;

/**
 * The <code>Main</code> is the main command-line application for the asteroids player.
 * <p>
 * It takes one optional command-line parameter: <code>server</code> (defaults to 127.0.0.1)
 */
public class Main {
	/**
	 * The main method.
	 *
	 * @param args
	 * 			the command-line parameters
	 * @throws Exception
	 */
	public static void main(String[] args) throws Exception,
			UnknownHostException {
		// takes one parameter (defaults to 127.0.0.1)
		if (args.length > 1) {
			System.out.println("usage: " + Main.class.getCanonicalName() + " <server>");
			return;
		}
		String serverName = "127.0.0.1"; // default server
		if (args.length == 1)
			serverName = args[0];

		// initialize connection
		ServerConnection serverConnection = new ServerConnection(serverName);
		try {
			// play
			Player player = new Player(serverConnection);
			player.run();
		} catch (Exception e) {
			serverConnection.close();
			throw e;
		}
	}
}
