package de.heise.anniversary.contest;

/**
 * The <code>Saucer</code> class represents a flying saucer.
 * <p>
 * A flying saucer has a position and a size.
 * @see GameStatus
 */
public class Saucer extends Position {
	/**
	 * The <code>Size</code> enumeration represents the size of a flying saucer.
	 * <p>
	 * There are two different sizes.
	 */
	public enum Size {
		BIG() {
			public int getDistanceCorrection() { return 20 * 12;}
		},
		SMALL() {
			public int getDistanceCorrection() { return 10 * 6;}
		};
		/**
		 * Returns correction value for the squared distance.
		 *
		 * The calculation <code>width/2</code> * <code>height/2</code> is just an approximation.
		 *
		 * @return the correction value for the squared distance
		 */
		abstract public int getDistanceCorrection();
	}
	protected Size size;

	/**
	 * Initializes a new flying saucers with given position and size.
	 *
	 * @param x
	 *        x-coordinate
	 *
	 * @param y
	 *        y-coordinate
	 *
	 * @param size
	 *        the asteroid size
	 */
	public Saucer(int x, int y, Size size) {
		super(x, y);
		this.size = size;
	}

	/**
	 * Returns the flying saucers size.
	 *
	 * @return the size
	 */
	public Size getSize() {
		return size;
	}

	/**
	 * Sets the flying saucers size.
	 *
	 * @param size
	 * 			the size
	 */
	public void setSize(Size size) {
		this.size = size;
	}
}
