unit Asteroids_Main;

//V0.2 nderungen
//
// - Erkennt dropped Frames
// - Bewegungsanalyse der Objekte
// - Zielerfassung mit adaptiver Erkennung des bentigten "Vorlaufes"
//
// ToDo - Feindliche Schsse erkennen und im Ernstfall HYPERSPACE
// dx,dy durch Anzahl Framedifferenz teilen
// evtl. noch etwas an der Schussgenauigkeit arbeiten
// wenn kleiner Asteroid nicht so viele Schsse
// wenn keine Asteroiden, dann mitte anstreben

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, IdBaseComponent, IdComponent, IdUDPBase, IdUDPClient, IdGlobal,
  StdCtrls, BufferInterpretieren;

type
  TForm1 = class(TForm)
    IdUDPClient1: TIdUDPClient;
    Memo1: TMemo;
    Memo2: TMemo;
    Button1: TButton;
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    Procedure Dump;
  end;

const
  Host 		 	  = '127.0.0.1';                    //Adresse des Rechners auf dem MAME luft
  ScreenSizeX = 1024;
  ScreenSizeY = 768;
  ScreenMinY  = 128;
  ScreenMaxY  = 895;
  DoDump      = False;
  LookAhead   = 30;                             //Frameanzahl fr in die Zukunft schauen

type
  TAsteroids = record
    x        	 : integer;
    y	 		     : integer;
    Typ        : integer;
    size       : integer;
    dx 		 		 : integer;
    dy 		 		 : integer;
    entf		   : integer;
    vx,vy      : integer;
    danger     : boolean;
    dumpLine   : integer;
  end;
  TShots = record
    x 		 		 : integer;
    y 		 		 : integer;
    speed 		 : Integer;
    dx 		 		 : integer;
    dy 		 		 : integer;
    vx,vy      : integer;
    size       : integer;
    danger     : boolean;
    dumpline   : integer;
  end;
  TShip = record
    x		 		   : integer;                  //aktuelle Position
    y		 		   : integer;
    dx		 	   : integer;                  //x-Vektor des fliegenden Schiffes
    dy		 		 : integer;		 		 		 		 	 //y-Vektor des fliegenden Schiffes
    Orx		 		 : integer;                  //Orientierung in x-Achse
    Ory		 		 : integer;                  //Orientierung in y-Achse
    vx,vy      : integer;                  //Zuknftige Position
    present    : boolean;
    dumpLine   : integer;
  end;
  TUfo = record
    x		 		   : integer;
    y		 		   : integer;
    size		   : integer;
    dx		 		 : integer;
    dy		 		 : integer;
    entf       : integer;
    present		 : boolean;
    vx,vy      : integer;                  //Zuknftige Position
    dumpLine   : integer;
  end;
  TAnzObjekte = record
    Asteroids, shots : integer;
  end;

  Function GameIntelligence:String;                                    //Berechnet Entfernungen und liefert die Aktionen in Form von Tastaturbefehlen zurck
  function Entfernung(x,y,s,x1,y1:integer):integer;                          //Ermittelt das Quadrat der Entfernung von x,y zu x1,y1
  Procedure Vector(x,y,x1,y1 :integer; var dx,dy:integer);                   //Ermittelt den Vector von x,y zu x1,y1


var
  Form1		 		 		 		 : TForm1;
  Buffer		 		 		   : Tbytes;
  Asteroids 		       : array[0..255,0..100] of TAsteroids;
  Shots		 		 		 		 : array[0..255,0..10] of TShots;
  Ships		 		 		 		 : array [0..255] of TShip;
  Ufos		 		 		     : array [0..255] of TUfo;
  Credits		 		 		   : Integer;
  T                    : Longint;
  DumpLines            : array[0..512]of String;
  DumpC                : integer;
  Drop_Frames, Akt_Frame, Last_Frame, Frame_Diff  : integer;
  Last, Actual, Max : TAnzObjekte;
  TimeStart,TimeEnd    : Real;
  Kreuzprodukt         : integer;
  Sc,Score,HighScore,wrap : integer;
  NextLevel               : boolean;
  Level                   : integer;

implementation

{$R *.dfm}

Procedure Tform1.Dump;
var i : integer;
    s : string;
begin
  i := 0;
  memo1.Lines.Clear;
  for i:= 0 to DumpC-1 do
    memo1.Lines.Append(DumpLines[i]);
  memo2.Lines.Clear;

  memo2.Lines.Append('Asteroiden #'+inttostr(actual.Asteroids));
  for i := 0 to actual.asteroids-1 do
    with asteroids[Akt_Frame,i] do
    memo2.Lines.Append('x= '+inttostr(x)+
                       '   y= '+inttostr(y)+
                       '   Size= '+inttostr(size)+
                       '   Entf= '+inttostr(entf)+
                       '   dx= '+inttostr(dx)+
                       '   dy= '+inttostr(dy)+
                       '   vx= '+inttostr(vx)+
                       '   vy= '+inttostr(vy)+
                       '   danger='+BoolToStr(danger)+
                       '   DumpLine= '+inttostr(Dumpline));

  memo2.Lines.Append('');
  memo2.Lines.Append('Shots #'+inttostr(actual.shots));
  for i := 0 to actual.shots-1 do
    with shots[Akt_Frame,i] do
    memo2.Lines.Append('x= '+inttostr(x)+
                       '   y= '+inttostr(y)+
                       '   dx= '+inttostr(dx)+
                       '   dy= '+inttostr(dy)+
                       '   vx= '+inttostr(vx)+
                       '   vy= '+inttostr(vy)+
                       '   danger='+BoolToStr(danger)+
                       '   DumpLine= '+inttostr(Dumpline));
  memo2.Lines.Append('');
  memo2.Lines.Append('Ship');
  with ships[Akt_Frame] do
    memo2.Lines.Append('x= '+inttostr(x)+
                       '   y= '+inttostr(y)+
                       '   OriX= '+inttostr(OrX)+
                       '   OriY= '+inttostr(Ory)+
                       '   dx= '+inttostr(dx)+
                       '   dy= '+inttostr(dy)+
                       '   vx= '+inttostr(vx)+
                       '   vy= '+inttostr(vy)+
                       '   DumpLine= '+inttostr(Dumpline));
  memo2.Lines.Append('');
  memo2.Lines.Append('Ufo');
  with Ufos[Akt_Frame] do
    memo2.Lines.Append('x= '+inttostr(x)+
                       '   y= '+inttostr(y)+
                       '   dx= '+inttostr(dx)+
                       '   dy= '+inttostr(dy)+
                       '   vx= '+inttostr(vx)+
                       '   vy= '+inttostr(vy)+
                       '   DumpLine= '+inttostr(Dumpline));

  memo2.Lines.Append('');
  memo2.Lines.Append('Spielzeit (s) = '+FloatToStr((Gettickcount-TimeStart)/1000));

  memo2.Lines.Append('');
  memo2.Lines.Append('Score = '+inttostr(score));
  memo2.Lines.Append('HighScore = '+inttostr(Highscore));

  memo2.Lines.Append('');
  memo2.Lines.Append('Level = '+inttostr(Level));

  memo2.Lines.Append('');
  memo2.Lines.Append('Frames (t) = '+inttostr(t));

  memo2.Lines.Append('');
  memo2.Lines.Append('Credits= '+inttostr(Credits));

  memo2.Lines.Append('');
  memo2.Lines.Append('Dropped Frames = '+inttostr(Drop_Frames));

  memo2.Lines.Append('');
  memo2.Lines.Append('Maximum Asteroids = '+inttostr(max.asteroids));
  memo2.Lines.Append('Maximum Shots = '+inttostr(max.shots));memo2.Lines.Append('');
end;


function GameIntelligence;
const
  Key_Hyperspace  = 1;
  Key_Fire 		 		= 2;
  Key_Thrust 		  = 4;
  Key_Right 		  = 8;
  Key_Left 		 		= 16;
  Signatur 		 		= 'ctmame';
var
  MinEntf,i,Entf,EntfZuk,dirx,diry,
  MinEntfZuk           	: integer;
  Keys					        : Byte;
  TargAst1,TargAst2     : TAsteroids;
  TargUfo               : TUfo;
  Ship                  : TShip;
  entf_fakt             : integer;
  Target                : boolean;

begin
  MinEntf := 1000 * 1000;
  MinEntfZuk := MinEntf;
  Keys := 0;						      //Alle Flags im Keys-Byte lschen
  inc(T);                     //Framezhler erhhen
  Ship := Ships[akt_frame];
  Target := false;

  if ship.present then
  begin
       TargUfo.x := 0; TargUfo.y := 0;

       for i := 0 to actual.Asteroids -1 do
       begin
         entf := entfernung(Asteroids[Akt_Frame,i].x,Asteroids[Akt_Frame,i].y,           //wie gross ist die aktuelle Entfernung
                 Asteroids[Akt_Frame,i].size,Ship.x,Ship.y);
         entfZuk := entfernung(Asteroids[Akt_Frame,i].vx,Asteroids[Akt_Frame,i].vy,      //wie gross ist die Entfernung in
                 Asteroids[Akt_Frame,i].size,Ship.vx,Ship.vy);                           //<LookAhead> Frames
         Asteroids[Akt_Frame,i].entf := entf;

         if (entf < MinEntf) then                                                        //Zuerst wird der Asteroid gesucht,
         begin                                                                           //aktuell die geringste Entfernung besitzt
           TargAst1 := Asteroids[Akt_Frame,i];
           target := true;
           minEntf := entf;
         end;

         if (entfZuk < MinEntfZuk) and (asteroids[Akt_Frame,i].danger) then              //Jetzt wird der Asteroid gesucht,
         begin                                                                           //der in <LookAhead>-Frames die
           TargAst2 := Asteroids[Akt_Frame,i];                                           //geringste Entfernung hat und auch noch
           target := true;
           minEntfZuk := entfZuk;                                                        //auf das Shiff zukommt
         end;
       end;

       if ufos[Akt_Frame].present then
       begin
         entf:= entfernung(Ufos[Akt_Frame].x,Ufos[Akt_Frame].y,
                Ufos[Akt_Frame].size,Ship.x,Ship.y);
         ufos[Akt_frame].entf := entf;
         if entf < MinEntf then
         begin
           TargUfo := Ufos[Akt_Frame];
           target := true;
           minEntf := entf;
         end;

         if MinEntfZuk < MinEntf then                                                      //Wenn der zuknftige Asteroid
         begin                                                                             //nher ist, als das aktuelle Ufo oder
           TargAst1 := TargAst2;                                                           //ein aktueller Asteroid, dann ist er das Ziel....
         end;

         if (Ufos[Akt_Frame].present) and (Ufos[Akt_Frame].size = 8) then                  //allerdings nur dann, wenn nicht noch
         begin                                                                             //ein kleines Ufo rumfliegt (PRIO 1)
           TargUfo := Ufos[Akt_Frame];
           target := true;                                                     //da dieses ziemlich genau schiesst
           //Keys := keys or Key_Thrust;                                                     //sollte man sich bewegen
         end;
       end;

       for i := 0 to actual.shots -1 do
         with shots[akt_frame,i] do
         begin
           if danger then
           begin
             entf := entfernung(x,y,size,Ship.x,Ship.y);
             if (entf < MinEntf) then                                                        //Zuerst wird der Asteroid gesucht,
               minEntf := entf;
           end;
         end;


       if MinEntf < 26*26 then                                                           //wenn ein aktuelles Objekt sehr nah ist
         keys := keys or Key_Hyperspace;                                                 //dann gibt es nur noch HYPER! HYPER!

       if (MinEntf > 350 * 350) and (actual.asteroids > 0) then                          //Wenn viel Platz ist, gib Shub
         keys := keys or Key_Thrust;

       // Schiff in Richtung auf das nchstgelegene Objekt drehen
	     // mathematisch wird hier das Kreuzprodukt aus den Vektoren
	     // ship_Orx/dy/0 und min_dx/y/0 berechnet

       if (TargUfo.x > 0) and (TargUfo.y > 0) then                                        //Jetzt versuche ich die Schussrichtung
       begin                                                                              //zu ermitteln
         with TargUfo do
         begin                                                                            //dabei ziele ich auf die zuknftige Position
           if entf > 0 then
           begin
             entf_fakt := round(sqrt(entf)) div 8;
             vx := x + dx*entf_fakt;                                                  //des Zielobjektes zu dem Zeitpunkt
             vy := y + dy*entf_fakt;
             vx := vx - ship.dx*entf_fakt;
             vy := vy - ship.dy*entf_fakt;                                                  //zu dem der Schuss eintrifft
           //Ships[Akt_Frame].vx := Ships[akt_frame].x +
           //                       Ships[akt_frame].dx*(entf div 64);                    //da sich der Schuss mit 8 Pixel/Frame
           //Ships[Akt_Frame].vy := Ships[akt_frame].y +                                  //bewegt, msste sich die quadratische
           //                       Ships[akt_frame].dy*(entf div 64);                    //Entfernung um 8x8 = 64 je Frame verringern
           //normalXY(Ships[Akt_Frame].vx,Ships[akt_frame].vy);                           //also muss ich aktuelle Entfernung durch 64 teilen
           normalXY(vx,vy);                                                               //und habe dann die Framezahl fr die Zukunfts-
           vector(vx,vy,Ship.x,Ship.y,dirx,diry);                                         //betrachtung
           end;

         end;
       end                                                                                //Jetzt "nur" noch die Positionen in x Frames fr Schiff und Ziel-
       else                                                                               //objekt ermitteln und darauf ausrichten
         with TargAst1 do
         begin
           if entf > 0 then
           begin
           entf_fakt := round(sqrt(entf)) div 8;
           vx := x + dx*entf_fakt;
           vy := y + dy*entf_fakt;
           vx := vx - ship.dx*entf_fakt;
           vy := vy - ship.dy*entf_fakt;
           //Ships[Akt_Frame].vx := Ships[akt_frame].x +
           //                       Ships[akt_frame].dx*(entf div 64);
           //Ships[Akt_Frame].vy := Ships[akt_frame].y +
           //                       Ships[akt_frame].dy*(entf div 64);
           //normalXY(Ships[Akt_Frame].vx,Ships[akt_frame].vy);
           normalXY(vx,vy);
           vector(vx,vy,Ship.x,Ship.y,dirx,diry);
           end;
         end;
       if target then
       begin
         kreuzprodukt := Ship.Orx * diry - ship.Ory * dirx;
         if kreuzprodukt > 0 then
           keys := keys or Key_Left
         else
           keys := keys or Key_Right;
         if abs(kreuzprodukt) < 9000 then keys := keys or Key_Fire;
       end
       {else
       begin
         vector(527,527,Ship.x,ship.y,dirx,diry);
         kreuzprodukt := Ship.Orx * diry - ship.Ory * dirx;
         if kreuzprodukt > 0 then
           keys := keys or Key_Left
         else
           keys := keys or Key_Right;
         if (abs(kreuzprodukt) < 15000)
         and (entfernung(527,527,10,ship.x,ship.y) > 150*150) then
           keys := keys or Key_Thrust;
       end;}
     end;
     if (not NextLevel) and (actual.Asteroids = 0) then
     begin
       inc(level);
       NextLevel := true;
       form1.Dump;
       form1.Repaint;
       application.ProcessMessages;
     end;
     if (nextLevel) and (actual.Asteroids > 0) then
       nextLevel := false;
   Result := Signatur+char(Keys)+char(0);
end;



Function Entfernung;
var
  EntfX,EntfY,Size : integer;
begin
  entfx := Abs(x - x1);                   //Absoluter abstand der x-Koordinate
  if entfx >= ScreenSizeX/2 then    	    //Wenn der Abstand grer ist als die halbe Bildschirmgre
    entfx := entfx - ScreensizeX;         //dann ist der Weg ber den Bildschirmrand krzer

  entfy := abs(y - y1);
  if entfy >= ScreenSizey/2 then
    entfy := entfy - Screensizey;

  Result := entfx*entfx + entfy*entfy -   //Entfernung als Quadrat der beiden Katheten
  			    s*s;                      	  //abzglich Quadrat der Gre des Objektes
end;

Procedure Vector;
begin
  dx := x - x1;
  if dx < - ScreenSizeX/2 then
    dx :=dx + ScreenSizeX
  else if dx >= ScreenSizeX/2 then
    dx := dx - ScreenSizeX;

  dy := y - y1;
  if dy < - ScreenSizeY/2 then
    dy := dy + ScreenSizeY
  else if dy >= ScreenSizey/2 then
    dy := dy - ScreenSizey;

end;

procedure TForm1.Button1Click(Sender: TObject);
var receiveBytes : integer;
begin
  SetLength(buffer,1026);
  IdUDPClient1.Active := true;
  IdUDPClient1.Host := Host;
  IdUDPClient1.Port := 1979;
  IdUDPClient1.Connect;
  T := 0;
  if IdUDPClient1.Connected then
  begin
    repeat
      IdUDPClient1.Send('ctmame'+char(0)+char(0));
      idUDPClient1.ReceiveBuffer(buffer,1026);
      AnalyzeBuffer(buffer);
    until ships[Akt_Frame].present;

    TimeStart                      := GetTickCount;
    Drop_Frames                    := 0;
    Last_Frame                     := Buffer[1024];
    max.Asteroids                  := 0;
    max.shots                      := 0;
    Wrap                           := 0;
    Sc                             := 0;
    Score                          := 0;
    HighScore                      := 0;
    Level                          := 0;
    NextLevel                      := false;

    repeat
      ReceiveBytes := IdUDPClient1.ReceiveBuffer(buffer,1026);
      if receiveBytes < 1026 then break;
      AnalyzeBuffer(buffer);
      if actual.Asteroids = last.asteroids then
      begin
        AbstandErmitteln;
        IdUDPClient1.Send(GameIntelligence);
      end;

      Last_Frame := Akt_Frame;
      last := actual;
    until ((not ships[Akt_Frame].present) and (credits = 0)); // or (T >= 60*300);
    TimeEnd := GetTickCount;
  dump;
  IdUDPClient1.Active := false;
  end;
end;

end.
