// Collector.cs created with MonoDevelop
// User: epsilon at 20:53 12.05.2008
//
// To change standard headers go to Edit->Preferences->Coding->Standard Headers
//

using System;
using Framework1;

namespace DataCollector
{
	
	
	public class Collector : Framework1.StatisticsPluginTemplate
	{
		// fields
		private System.Collections.Generic.Queue<DateTime> theFrameTimes
			= new System.Collections.Generic.Queue<DateTime>();
		private int theFrameCount = 0;
		private DateTime theFirstFrameTime;

		
		// properties
		public double FpsLast1
		{
			get
			{
				if (theFrameTimes.Count < 2)
					return -1.0;
				else
					return 1.0 / (theFrameTimes.ToArray()[theFrameTimes.Count - 1]
					              - theFrameTimes.ToArray()[theFrameTimes.Count - 2]).TotalSeconds;
			}
		}
		
		public double FpsLast10
		{
			get 
			{ 
				if (theFrameTimes.Count < 10)
					return -1.0;
				else
					return 10.0 / (theFrameTimes.ToArray()[9] - theFrameTimes.ToArray()[0]).TotalSeconds;
			}
		}
		
		public double FpsTotal
		{
			get { return (double)theFrameCount / (DateTime.Now - theFirstFrameTime).TotalSeconds; }
		}
		
		
		// constructor
		public Collector()
		{
		}
		
		
		// methods
		public override void UpdatePlayfield (Playfield playfield)
		{
			theFrameCount++;
			
			// first frame?
			if (theFrameCount == 1)
				theFirstFrameTime = DateTime.Now;
			
			// store time of last ten frames
			theFrameTimes.Enqueue(DateTime.Now);
			if (theFrameTimes.Count > 10)
				theFrameTimes.Dequeue();
			
			if (theFrameCount % 100 == 0)
			{
				LogOutput.LogInfo(this.ToString(), "FPS 1 : "
				                  + this.FpsLast1 + ", 10 : " + this.FpsLast10
				                  + ", total : " + this.FpsTotal);
			}
			else
			{
				LogOutput.LogDebug(this.ToString(), "FPS 1 : "
				                   + this.FpsLast1 + ", 10 : " + this.FpsLast10
				                   + ", total : " + this.FpsTotal);
			}
		}

		public override string ToString ()
		{
			return "DataCollector";
		}

	}
}
