// /home/epsilon/Projects/Asteroid/ABot/Framework1/Framework1/IBotPlugin.cs created with MonoDevelop
// User: epsilon at 16:48 19.04.2008
//

using System;

namespace Framework1
{
	public interface IBotPlugin : IPlugin
	{
		event ChangeKeysEventHandler ChangeKeys;
		event ChangeBotStatusEventHandler ChangeBotStatus;
	}

	// ChangeKeysEvent
	public delegate void ChangeKeysEventHandler(object sender, ChangeKeysEventArgs e);

	public class ChangeKeysEventArgs : EventArgs
	{
		public KeySet keys;
	}

	// ChangeBotStatusEvent
	public delegate void ChangeBotStatusEventHandler(object sender, ChangeBotStatusEventArgs e);

	public class ChangeBotStatusEventArgs : EventArgs
	{
		public BotStatus status;
	}

	
	// Template class
	public abstract class BotPluginTemplate : IBotPlugin
	{
		// fields
		private IPluginHost theHost;

		// properties
		public PluginTypes PluginType
		{
			get { return PluginTypes.BotPlugin;}
		}
		
		public IPluginHost Host
		{
			set
			{
				theHost = value;
				theHost.RegisterPlugin(this);
			}
		}
		

		// methods
		public override string ToString()
		{
			return "BotPlugin";
		}
		
		public virtual void UpdatePlayfield(Playfield playfield)
		{
		}

		public virtual void UpdateCurrentKeys(KeySet keys)
		{
		}

		public virtual void UpdateCalibration(GameCalibration calibration)
		{
		}
		
		public virtual void UpdateBotStatus(BotStatus status)
		{
		}

		// events
		public event ChangeKeysEventHandler ChangeKeys;
		
		protected virtual void OnChangeKeys(ChangeKeysEventArgs e)
		{
			if (ChangeKeys != null)
				ChangeKeys(this, e);
		}		

		
		public event ChangeBotStatusEventHandler ChangeBotStatus;
		
		protected virtual void OnChangeBotStatus(ChangeBotStatusEventArgs e)
		{
			if (ChangeBotStatus != null)
				ChangeBotStatus(this, e);
		}		
	}
}
