// /home/epsilon/Projects/Asteroid/ABot/Framework1/Framework1/KeySet.cs created with MonoDevelop
// User: epsilon at 16:26 19.04.2008
//

using System;

namespace Framework1
{
	
	
	public class KeySet
	{
		public enum Keys{HyperSpace = 1,Fire = 2,Thrust = 4,Right = 8,Left = 16}
		
		//Fields
		private byte theKeys = 0;
		//Properties
		//Methods
		///markes a Key to be pushed in the next frame
		public void PushKey(Keys key)
		{
			theKeys= (byte)(theKeys | (byte)key);		
			LogOutput.LogDebug("KeySet","Pushed "+key.ToString());
		}
		public bool IsPushed(Keys key)
		{
			return (int)(theKeys & (byte)key) != 0;
		}
		///returns Bytecode to send current presed keys with pingbyte [ping]
		public byte[] ToByteArray(byte ping)
		{
			byte[] byts  = new byte[8];
			
			byts[0] = (byte)'c';
			byts[1] = (byte)'t';
			byts[2] = (byte)'m';
			byts[3] = (byte)'a';
			byts[4] = (byte)'m';
			byts[5] = (byte)'e';
			byts[6] = (byte)theKeys;
			byts[7] = (byte)ping;
			
			return byts;
		}
		
		public KeySet()
		{
		}
		
		public KeySet Clone()
		{
			KeySet returnValue = new KeySet();
			returnValue.theKeys = this.theKeys;
			return returnValue;
		}
		
		///releases all pushed keys 
		//TODO should be called after transmitting a Keyframe.
		public void ReleaseKeys()
		{
			theKeys = 0;
		}
		///put out a readable string of the pushed Keys.
		public override string ToString()
		{
			string result = "[";
			foreach(Keys key in Enum.GetValues(typeof(Keys)))
			{
				if(IsPushed(key))
					result +=key.ToString()+",";
			}
				
			return result+"]";
		}
		/// test KeySet's capabilities and reports to LogInfo
		public static void Test()
		{
			KeySet ks = new KeySet();
			LogOutput.LogInfo("KeySet","Testing KeySet");
			ks.ReleaseKeys();
			LogOutput.LogInfo(ks.ToString());
			LogOutput.LogInfo("KeySet","  Pushing Fire");
			ks.PushKey(Keys.Fire);
			LogOutput.LogInfo(ks.ToString());
			LogOutput.LogInfo("KeySet","  Releasing Keys");
			ks.ReleaseKeys();
			LogOutput.LogInfo(ks.ToString());
			LogOutput.LogInfo("KeySet","Done.");
		}
	}
}
