using System;
using System.Collections.Generic;
using System.Text;

namespace GLUtils
{
    public class GLTexture
    {
        // member
        //========
        private readonly System.Drawing.Bitmap theTexture;
        private readonly string theName;


        // properties
        //============
        /// <summary>
        /// Bitmap containing the texture itself
        /// </summary>
        public System.Drawing.Bitmap Texture
		{ 
			get { return theTexture; }
		}

        /// <summary>
        /// String containing the textures name
        /// </summary>
        public string Name 
		{
			get { return theName; }
		}


        // constructors
        //==============
        /// <summary>
        /// Construct texture from file
        /// </summary>
        /// <param name="name"></param>
        /// <param name="path"></param>
        public GLTexture(string name, string path)
        {
            theName = name;
			theTexture = new System.Drawing.Bitmap(path);
        }

        /// <summary>
        /// Construct texture from stream
        /// </summary>
        /// <param name="name"></param>
        /// <param name="stream"></param>
        public GLTexture(string name, System.IO.Stream stream)
        {
            theName = name;
			theTexture = (System.Drawing.Bitmap)System.Drawing.Bitmap.FromStream(stream);
        }
    }
}
