// GLAsteroidHUD.cs created with MonoDevelop
// User: epsilon at 21:03 31.05.2008
//
// To change standard headers go to Edit->Preferences->Coding->Standard Headers
//

using System;
using GLUtils;
using Tao.OpenGl;


namespace GLVisualizer
{
	public class GLTargetHUD : GLUtils.GLObject
	{
		// consts
		//--------
		private const float theIngameSpeedScale = 20.0f;
		private const float theIngameSpeedArrowTipLength = 10.0f;
		
		private readonly Vector3 theArrowColor = new Vector3(1.0f, 1.0f, 0.0f);
		private readonly Vector3 theTarget1Color = new Vector3(1.0f, 0.0f, 0.0f);
		private readonly Vector3 theTarget2Color = new Vector3(1.0f, 0.5f, 0.0f);
		
		
		// fields
		//--------
		private GLUtils.Vector3 theIngameSpeed = new Vector3();
		private bool theIsTarget1 = false;
		private bool theIsTarget2 = false;
		
		
		// properties
		//------------
		public bool IsTarget1
		{
			get { return theIsTarget1; }
			set { theIsTarget1 = value; }
		}
		
		public bool IsTarget2
		{
			get { return theIsTarget2; }
			set { theIsTarget2 = value; }
		}

		
        // constructor: position, size
        public GLTargetHUD(Vector3 position, Vector3 size)
			: base (position, size)
        {
			this.Color = new Vector3(1.0f, 1.0f, 1.0f);
			this.ObjectType = ObjectTypes.HUD;
        }

        // constructor: position
        public GLTargetHUD(Vector3 position)
            : base(position)
		{
			this.Color = new Vector3(1.0f, 1.0f, 1.0f);
			this.ObjectType = ObjectTypes.HUD;
		}
		
		public GLTargetHUD()
			: base()
		{
			this.Color = new Vector3(1.0f, 1.0f, 1.0f);
			this.ObjectType = ObjectTypes.HUD;
		}
		

		public override void Draw()
		{
            Gl.glLoadIdentity(); // Reset The Current Modelview Matrix
            Gl.glTranslatef(thePosition.X, thePosition.Y, thePosition.Z);

			// draw speed arrows
			GLScreen.UnbindTexture();

			if (theUseAlphaBlending)
            {
                Gl.glEnable(Gl.GL_BLEND);
                Gl.glColor4f(theArrowColor.X, theArrowColor.Y, theArrowColor.Z, theAlphaBlending);
            }
            else
            {
                Gl.glDisable(Gl.GL_BLEND);
                Gl.glColor3f(theArrowColor.X, theArrowColor.Y, theArrowColor.Z);
            }
			
			Gl.glBegin(Gl.GL_LINES);
			{
				Gl.glVertex3f(0.0f, 0.0f, 0.0f); // center
				Gl.glVertex3f(theIngameSpeed.X*theIngameSpeedScale/Visualizer.theScale,
				              theIngameSpeed.Y*theIngameSpeedScale/Visualizer.theScale, 0.0f); // tip

				Gl.glVertex3f(theIngameSpeed.X*theIngameSpeedScale/Visualizer.theScale,
				              theIngameSpeed.Y*theIngameSpeedScale/Visualizer.theScale, 0.0f); // tip
				Gl.glVertex3f((theIngameSpeed.X*theIngameSpeedScale - theIngameSpeedArrowTipLength*(float)Math.Cos(theIngameSpeed.Phi + Math.PI/4))/Visualizer.theScale,
				              (theIngameSpeed.Y*theIngameSpeedScale - theIngameSpeedArrowTipLength*(float)Math.Sin(theIngameSpeed.Phi + Math.PI/4))/Visualizer.theScale,
				              0.0f); // right corner
				
				Gl.glVertex3f(theIngameSpeed.X*theIngameSpeedScale/Visualizer.theScale,
				              theIngameSpeed.Y*theIngameSpeedScale/Visualizer.theScale, 0.0f); // tip
				Gl.glVertex3f((theIngameSpeed.X*theIngameSpeedScale - theIngameSpeedArrowTipLength*(float)Math.Cos(theIngameSpeed.Phi - Math.PI/4))/Visualizer.theScale,
				              (theIngameSpeed.Y*theIngameSpeedScale - theIngameSpeedArrowTipLength*(float)Math.Sin(theIngameSpeed.Phi - Math.PI/4))/Visualizer.theScale,
				              0.0f); // left corner
			}
			Gl.glEnd();


			if (this.IsTarget2)
			{
				if (theUseAlphaBlending)
				{
					Gl.glEnable(Gl.GL_BLEND);
					Gl.glColor4f(theTarget2Color.X, theTarget2Color.Y, theTarget2Color.Z, theAlphaBlending);
				}
				else
				{
					Gl.glDisable(Gl.GL_BLEND);
					Gl.glColor3f(theTarget2Color.X, theTarget2Color.Y, theTarget2Color.Z);
				}

				Gl.glBegin(Gl.GL_TRIANGLE_STRIP); // draw a quad using a triangle strip
				{
					Gl.glTexCoord2f(0.0f, 0.0f);
					Gl.glVertex3f(-0.5f * theSize.X, 0.5f * theSize.Y, 0.0f); // upper left corner
					Gl.glTexCoord2f(1.0f, 0.0f);
					Gl.glVertex3f(0.5f * theSize.X, 0.5f * theSize.Y, 0.0f); // upper right corner
					Gl.glTexCoord2f(0.0f, 1.0f);
					Gl.glVertex3f(-0.5f * theSize.X, -0.5f * theSize.Y, 0.0f); // lower left corner
					Gl.glTexCoord2f(1.0f, 1.0f);
					Gl.glVertex3f(0.5f * theSize.X, -0.5f * theSize.Y, 0.0f); // lower right corner
				}
				Gl.glEnd();	// done drawing the triangle strip
			}

			if (this.IsTarget1)
			{
				// rotate 45 degrees
				Gl.glRotatef(45.0f, 0.0f, 0.0f, 1.0f);

				if (theUseAlphaBlending)
				{
					//Gl.glEnable(Gl.GL_BLEND);
					Gl.glColor4f(theTarget1Color.X, theTarget1Color.Y, theTarget1Color.Z, theAlphaBlending);
				}
				else
				{
					//Gl.glDisable(Gl.GL_BLEND);
					Gl.glColor3f(theTarget1Color.X, theTarget1Color.Y, theTarget1Color.Z);
				}

				Gl.glBegin(Gl.GL_TRIANGLE_STRIP); // draw a quad using a triangle strip
				{
					Gl.glTexCoord2f(0.0f, 0.0f);
					Gl.glVertex3f(-0.5f * theSize.X, 0.5f * theSize.Y, 0.0f); // upper left corner
					Gl.glTexCoord2f(1.0f, 0.0f);
					Gl.glVertex3f(0.5f * theSize.X, 0.5f * theSize.Y, 0.0f); // upper right corner
					Gl.glTexCoord2f(0.0f, 1.0f);
					Gl.glVertex3f(-0.5f * theSize.X, -0.5f * theSize.Y, 0.0f); // lower left corner
					Gl.glTexCoord2f(1.0f, 1.0f);
					Gl.glVertex3f(0.5f * theSize.X, -0.5f * theSize.Y, 0.0f); // lower right corner
				}
				Gl.glEnd();	// done drawing the triangle strip
			}
				
			Gl.glDisable(Gl.GL_BLEND);			
		}

		public void UpdateProperties(Framework1.Sprite sprite)
		{
			// position asteroid
			this.Position.X = ((float)sprite.Position.X + Visualizer.theOffsetX)/Visualizer.theScale;
			this.Position.Y = ((float)sprite.Position.Y + Visualizer.theOffsetY)/Visualizer.theScale;
			this.Position.Z = Visualizer.thePlayfieldZ;

			this.Size = Visualizer.theLargeAsteroidSize;
			if (sprite.HitRadius == 14)
				this.Size = Visualizer.theSmallAsteroidSize;
			if (sprite.HitRadius == 15)
				this.Size = Visualizer.theMediumAsteroidSize;

			if (sprite.SpeedKnown){
				this.theIngameSpeed.X = (float)sprite.Speed.X;
				this.theIngameSpeed.Y = (float)sprite.Speed.Y;
			}
		}
	}
}
