// algo.hpp
// --------
//
//  (C) Copyright Gerald Thaler 2008.
//
// Distributed under the Boost Software License, Version 1.0.
//    (See accompanying file LICENSE_1_0.txt or copy at
//          http://www.boost.org/LICENSE_1_0.txt)

#ifndef INTREPID_ALGO_HPP
#define INTREPID_ALGO_HPP

#if defined(_MSC_VER) && (_MSC_VER >= 1200)
# pragma once
#endif // defined(_MSC_VER) && (_MSC_VER >= 1200)

namespace intrepid
{
    template<class Range, class T>
    inline void fill(Range &range, T const &value)
    {
        fill(boost::begin(range),
             boost::end(range),
             value);
    }

    template<class Range, class OutputIterator>
    inline void copy(Range const &range, OutputIterator result)
    {
        copy(boost::begin(range),
             boost::end(range),
             result);
    }

    template<class Range, class T>
    inline typename Range::const_iterator lower_bound(Range const &range,
                                                      T const &value)
    {
        return lower_bound(boost::begin(range),
                           boost::end(range),
                           value);
    }

    template<class Range>
    inline void sort(Range &range)
    {
        sort(boost::begin(range),
             boost::end(range));
    }

    template<class Range, class T>
    inline typename Range::const_iterator upper_bound(Range const &range,
                                                      T const &value)
    {
        return upper_bound(boost::begin(range),
                           boost::end(range),
                           value);
    }
} // end of namespace intrepid

#endif // include guard
