// intrepid.hpp
// ------------
//
//  (C) Copyright Gerald Thaler 2008.
//
// Distributed under the Boost Software License, Version 1.0.
//    (See accompanying file LICENSE_1_0.txt or copy at
//          http://www.boost.org/LICENSE_1_0.txt)

#ifndef INTREPID_INTREPID_HPP
#define INTREPID_INTREPID_HPP

#if defined(_MSC_VER) && (_MSC_VER >= 1200)
# pragma once
#endif // defined(_MSC_VER) && (_MSC_VER >= 1200)

// Cleanup some macro name pollution, caused by legacy C headers.

#ifdef max
#undef max
#endif

#ifdef min
#undef min
#endif

// Register some types and templates for use with Boost.Typeof.

#include BOOST_TYPEOF_INCREMENT_REGISTRATION_GROUP()
BOOST_TYPEOF_REGISTER_TEMPLATE(boost::_bi::bind_t, 3)
BOOST_TYPEOF_REGISTER_TEMPLATE(boost::_bi::list1, 1)
BOOST_TYPEOF_REGISTER_TEMPLATE(boost::_bi::value, 1)
BOOST_TYPEOF_REGISTER_TEMPLATE(boost::_mfi::mf0, 2)
BOOST_TYPEOF_REGISTER_TEMPLATE(boost::asio::basic_socket, 2)
BOOST_TYPEOF_REGISTER_TEMPLATE(boost::asio::datagram_socket_service, 1)
BOOST_TYPEOF_REGISTER_TYPE(boost::asio::ip::udp)
BOOST_TYPEOF_REGISTER_TYPE(boost::asio::ip::udp::socket)

// Import some names from boost and std into namespace intrepid.

namespace intrepid
{
    namespace asio = boost::asio;
    namespace posix_time = boost::posix_time;
    namespace this_thread = boost::this_thread;

    using boost::Generator;

    using boost::array;
    using boost::bind;
    using boost::condition_variable;
    using boost::int8_t;
    using boost::integer_traits;
    using boost::iterator_range;
    using boost::lexical_cast;
    using boost::mutex;
    using boost::scoped_array;
    using boost::system::error_code;
    using boost::system::system_category;
    using boost::system::system_error;
    using boost::thread;
    using boost::thread_interrupted;
    using boost::uint8_t;
    using boost::uint16_t;
    using boost::unique_lock;

    using std::abs;
    using std::basic_ostream;
    using std::clog;
    using std::copy;
    using std::cout;
    using std::endl;
    using std::exception;
    using std::fill;
    using std::lower_bound;
    using std::max;
    using std::min;
    using std::pair;
    using std::ptrdiff_t;
    using std::runtime_error;
    using std::sort;
    using std::size_t;
    using std::string;
    using std::upper_bound;
    using std::vector;

    BOOST_STATIC_ASSERT(integer_traits<uint8_t>::digits == 8);
    BOOST_STATIC_ASSERT(integer_traits<uint8_t>::const_min == 0);
    BOOST_STATIC_ASSERT(integer_traits<uint8_t>::const_max == 255);

    BOOST_STATIC_ASSERT(integer_traits<uint16_t>::digits == 16);
    BOOST_STATIC_ASSERT(integer_traits<uint16_t>::const_min == 0);
    BOOST_STATIC_ASSERT(integer_traits<uint16_t>::const_max == 65535);

    BOOST_STATIC_ASSERT(integer_traits<int8_t>::digits == 7);
    BOOST_STATIC_ASSERT(integer_traits<int8_t>::const_min == -128);
    BOOST_STATIC_ASSERT(integer_traits<int8_t>::const_max == +127);
    // Assert two's complement uint8_t -> int8_t conversion:
    BOOST_STATIC_ASSERT(static_cast<int8_t>(
                                        static_cast<uint8_t>(255)) == -1);
    BOOST_STATIC_ASSERT(static_cast<int8_t>(
                                        static_cast<uint8_t>(129)) == -127);
    BOOST_STATIC_ASSERT(static_cast<int8_t>(
                                        static_cast<uint8_t>(128)) == -128);

    inline int8_t byte_diff(uint8_t b1, uint8_t b2)
    {
        unsigned int n1 = b1;
        unsigned int n2 = b2;
        return static_cast<uint8_t>(n1 - n2);
    }

    inline bool byte_less_than(uint8_t b1, uint8_t b2)
    {
        return byte_diff(b2, b1) > 0;
    }

    inline int ceiling_division(int a, int b)
    {
        assert(b > 0);
        // assume rounding towards zero
        if (a <= 0)
        {
            return a / b;
        }
        else
        {
            // a > 0
            return (a + b - 1) / b;
        }
    }

    inline int floor_division(int a, int b)
    {
        assert(b > 0);
        // assume rounding towards zero
        if (a >= 0)
        {
            return a / b;
        }
        else
        {
            // a < 0
            return (a - b + 1) / b;
        }
    }

    inline uint8_t max_byte(uint8_t b1, uint8_t b2)
    {
        return byte_diff(b1, b2) >= 0 ? b1 : b2;
    }

    inline uint8_t min_byte(uint8_t b1, uint8_t b2)
    {
        return byte_diff(b1, b2) >= 0 ? b2 : b1;
    }

} // end of namespace intrepid

#endif // include guard
