// player_impl.hpp
// --------------
//
//  (C) Copyright Gerald Thaler 2008.
//
// Distributed under the Boost Software License, Version 1.0.
//    (See accompanying file LICENSE_1_0.txt or copy at
//          http://www.boost.org/LICENSE_1_0.txt)

#ifndef INTREPID_PLAYER_IMPL_HPP
#define INTREPID_PLAYER_IMPL_HPP

#if defined(_MSC_VER) && (_MSC_VER >= 1200)
# pragma once
#endif // defined(_MSC_VER) && (_MSC_VER >= 1200)

#include "parse_frame.hpp"
#include "screen_state.hpp"
#include "strategy.hpp"
#include "thread_comm.hpp"

namespace intrepid
{
    class player_impl
    {
    public:
        player_impl();

        uint8_t next_frame(uint8_t ping,
                           comm_model::frame_packet const &frame,
                           comm_model::ping_to_keys_map const &ping_to_keys);
        void start();
        void stop();

    private:
        player_impl(player_impl const &); // = delete;
        player_impl &operator=(player_impl const &); // = delete;

        int get_nof_threads() const;

        void parse_next_frame(
                          uint8_t const vectorram[comm_model::vectorram_size]);
        void start_threads();
        void stop_threads();
        void thread_proc(int thread_nr);

        static int const default_num_threads = 2;
        static int const max_threads = 1;

        typedef array<thread, max_threads> thread_container;
        typedef iterator_range<thread_container::iterator> thread_range;

        int               nof_threads_;
        parsed_frame      parsed_frame_;
        thread_comm       thread_comm_;
        thread_container  thread_container_;
        thread_range      threads_;

        // Order dependency:
        // screen_state_ must be constructed before strategy_.
        screen_state      screen_state_;
        strategy          strategy_;
    };
} // end of namespace intrepid

#include BOOST_TYPEOF_INCREMENT_REGISTRATION_GROUP()
BOOST_TYPEOF_REGISTER_TYPE(intrepid::player_impl)

#endif // include guard
