// scope_exit.hpp
// --------------
//
//  (C) Copyright Gerald Thaler 2008.
//
// Distributed under the Boost Software License, Version 1.0.
//    (See accompanying file LICENSE_1_0.txt or copy at
//          http://www.boost.org/LICENSE_1_0.txt)

#ifndef INTREPID_SCOPE_EXIT_HPP
#define INTREPID_SCOPE_EXIT_HPP

#if defined(_MSC_VER) && (_MSC_VER >= 1200)
# pragma once
#endif // defined(_MSC_VER) && (_MSC_VER >= 1200)

namespace intrepid
{
    template<class Func>
    class scope_exit_guard
    {
        BOOST_CONCEPT_ASSERT((Generator<Func, void>));
    public:
        explicit scope_exit_guard(Func const &f);
        ~scope_exit_guard();

    private:
        scope_exit_guard(scope_exit_guard<Func> const &c); // = delete;
        scope_exit_guard<Func> &
            operator=(scope_exit_guard<Func> const &c); // = delete;

        Func f_;
    };

// class scope_exit_guard
// public:

    template<class Func>
    inline scope_exit_guard<Func>::scope_exit_guard(Func const &f)
        :   f_(f)
    {
        // empty
    }

    template<class Func>
    inline scope_exit_guard<Func>::~scope_exit_guard()
    {
        f_();
    }

} // end of namespace intrepid

#define INTREPID_ON_SCOPE_EXIT(c) \
    scope_exit_guard<BOOST_TYPEOF(c)> on_scope_exit(c)

#endif // include guard
