#include "GameObject.h"

void GameObject::calcSpeed()
{
	speed = dir.Length();

}

bool GameObject::Intersects(GameObject f1, float &s0, float &s1)
{
	// The intersection of two lines is a solution to P0 + s0*D0 = P1 + s1*D1.
	// Rewrite this as s0*D0 - s1*D1 = P1 - P0 = Q.  
	// If D0.Dot(Perp(D1)) = 0, the lines are parallel.  Additionally, 
	//   if Q.Dot(Perp(D1)) = 0, the lines are the same.  
	// If D0.Dot(Perp(D1)) is not zero, then 
	//   s0 = Q.Dot(Perp(D1)) / D0.Dot(Perp(D1))
	// produces the point of intersection.  Also,
	//   s1 = Q.Dot(Perp(D0)) / D0.Dot(Perp(D1)) 

	float dot0 = dir.Dot(f1.dir.Perp());

	if (dot0 > 0.000005 || dot0 < -0.000005)
	{
		Vector2D Q = f1.position - position;
		s0 = Q.Dot(f1.dir.Perp()) / dot0;
		s1 = Q.Dot(   dir.Perp()) / dot0; //false
		return true;
	}
	else 
	{
		s0 = 0;
		s1 = 0;
		return false;
	}
}