#pragma once
#include "Vector2D.h"
#include <math.h>
#include "directions.h"

const double PI		  = 3.14159265358979323846;
const double DEG2RAD  = 3.14159265358979323846 / 180;
const double RAD2DEG  = 180 / 3.14159265358979323846;
	

class GameObject
{
public:
	bool    isPresent;  // flag if flyer is used or visible
	Vector2D   position;     // current position
	Vector2D   dir;        // flying direction
	Vector2D   dirplotting[8];
	bool plotted;
	double  angleDEG;   // flying angle in degrees
	float   speed;      // speed in pixels per frame
	int     nFramesOld; // No. of frames to the old position
	float   r;          // radius in pixels
	float   rcol;       // collision radius
	Directions* shotVector;
	 

	  
	void calcSpeed();
	  
	bool Intersects(GameObject f1, float &s0, float &s1);
};
