#pragma once
#include <math.h>


class Vector2D
{
    public:

        float   x;
        float   y;
        
        Vector2D() {}
        
        Vector2D(float r, float s)
        {
            x = r;
            y = s;
        }

        Vector2D& Set(float r, float s)
        {
            x = r;
            y = s;
            return (*this);
        }

		double Length()
		{
			return (sqrt(x * x + y * y));
		}

		Vector2D Perp()
		{
			return Vector2D(-y,x);
		}

		double Dot(Vector2D v)
		{
			return (*this) * v;
		}

		double AngleDEG()
		{
			double angle = atan2(y,x) * 180 / 3.14159265358979323846;
			if (angle < 0) angle = 360 + angle;
			return angle;
		}
        
        float& operator [](long k)
        {
            return ((&x)[k]);
        }
        
        const float& operator [](long k) const
        {
            return ((&x)[k]);
        }
        
        Vector2D& operator +=(const Vector2D& v)
        {
            x += v.x;
            y += v.y;
            return (*this);
        }
        
        Vector2D& operator -=(const Vector2D& v)
        {
            x -= v.x;
            y -= v.y;
            return (*this);
        }
        
        Vector2D& operator *=(float t)
        {
            x *= t;
            y *= t;
            return (*this);
        }
        
        Vector2D& operator /=(float t)
        {
            float f = 1.0F / t;
            x *= f;
            y *= f;
            return (*this);
        }
        
        Vector2D& operator &=(const Vector2D& v)
        {
            x *= v.x;
            y *= v.y;
            return (*this);
        }
        
        Vector2D operator -(void) const
        {
            return (Vector2D(-x, -y));
        }
        
        Vector2D operator +(const Vector2D& v) const
        {
            return (Vector2D(x + v.x, y + v.y));
        }
        
        Vector2D operator -(const Vector2D& v) const
        {
            return (Vector2D(x - v.x, y - v.y));
        }
        
        Vector2D operator *(float t) const
        {
            return (Vector2D(x * t, y * t));
        }
        
        Vector2D operator /(float t) const
        {
            float f = 1.0F / t;
            return (Vector2D(x * f, y * f));
        }
        
        float operator *(const Vector2D& v) const
        {
            return (x * v.x + y * v.y);
        }
        
        Vector2D operator &(const Vector2D& v) const
        {
            return (Vector2D(x * v.x, y * v.y));
        }
        
        bool operator ==(const Vector2D& v) const
        {
			float x1,x2,y1,y2;
			double d = pow(10.0,15);
			x1 = floor(x*d+0.5)/d;
			y1 = floor(y*d+0.5)/d;
			x2 = floor(v.x*d+0.5)/d;
			y2 = floor(v.y*d+0.5)/d;
            return ((x1 == x2) && (y1 == y2));
        }
        
        bool operator !=(const Vector2D& v) const
        {
            return ((x != v.x) || (y != v.y));
        }
        
        Vector2D& Normalize(void)
        {
            return (*this /= sqrtf(x * x + y * y));
        }
};

class Point2D : public Vector2D
{
    public:
        
        Point2D() {}
        
        Point2D(float r, float s) : Vector2D(r, s) {}
        
        Point2D& operator =(const Vector2D& v)
        {
            x = v.x;
            y = v.y;
            return (*this);
        }
        
        Point2D& operator *=(float t)
        {
            x *= t;
            y *= t;
            return (*this);
        }
        
        Point2D& operator /=(float t)
        {
            float f = 1.0F / t;
            x *= f;
            y *= f;
            return (*this);
        }
        
        Point2D operator -(void) const
        {
            return (Point2D(-x, -y));
        }
        
        Point2D operator +(const Vector2D& v) const
        {
            return (Point2D(x + v.x, y + v.y));
        }
        
        Point2D operator -(const Vector2D& v) const
        {
            return (Point2D(x - v.x, y - v.y));
        }
        
        Vector2D operator -(const Point2D& p) const
        {
            return (Vector2D(x - p.x, y - p.y));
        }
        
        Point2D operator *(float t) const
        {
            return (Point2D(x * t, y * t));
        }
        
        Point2D operator /(float t) const
        {
            float f = 1.0F / t;
            return (Point2D(x * f, y * f));
        }
};


inline Vector2D operator *(float t, const Vector2D& v)
{
    return (Vector2D(t * v.x, t * v.y));
}

inline Point2D operator *(float t, const Point2D& p)
{
    return (Point2D(t * p.x, t * p.y));
}

inline float Dot(const Vector2D& v1, const Vector2D& v2)
{
    return (v1 * v2);
}

inline float Magnitude(const Vector2D& v)
{
    return (sqrtf(v.x * v.x + v.y * v.y));
}

inline float InverseMag(const Vector2D& v)
{
    return (1.0F / sqrtf(v.x * v.x + v.y * v.y));
}

inline float SquaredMag(const Vector2D& v)
{
    return (v.x * v.x + v.y * v.y);
}

inline bool RaySphereIntersect(const Vector2D &origin, const Vector2D &target, float &targetRadius, Vector2D &aim)
{
	Vector2D toTarget = target - origin;
	float length = toTarget.Length();
	aim.Normalize();

	aim *= length;

	aim += origin;

	Vector2D targetDist = aim - target;
	float distance = targetDist.Length();

	if(distance < targetRadius)
		return true;
	else
		return false;
};

