// player.h: Beispielspieler fr Asteroids
// Harald Bgeholz / c't
#if defined(WINDOWS)
#define ADDRESS DWORD
#else
#define SOCKET int
#define ADDRESS in_addr_t
// 3 Includes fr sockaddr_in
#include <sys/types.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#endif

#include "vector"
#include "iostream"
#include "vector2D.h"
#include "Directions.h"
#include "asteroid.h"
#include "Ship.h"
#include "Ufo.h"
#include <queue>

using namespace std;

static const int MAX_ASTEROIDS = 100;
static const int MAX_SHOTS = 10;

class Shot
{
public:
	Point2D position;

	Vector2D dir;

	int  updateCounter;
	bool isPresent;

	bool syncCheck;

	bool PlayerShot;
	
	bool isEqual(Shot shot2);
	void set(int x, int y);
	Shot(){syncCheck = false;updateCounter = 0;}
};

class GameStatus
{
public:
	Ship ship;
	Ufo  ufo;
	//int nasteroids; // Anzahl Asteroiden
	vector<Asteroid*> asteroids;
	vector<Shot*> shots;
	void clear(void);
	bool shotLastFrame;
	bool shotThisFrame;
	Target* currentTarget;
	int asterTarget;

	int playerShots;

	queue<int> dirsync;

	float minDist;



	GameStatus(){shotLastFrame = shotThisFrame = false;playerShots = 0; currentTarget = NULL;minDist = 0x7FFFFFF;}
};

#pragma pack(1)
struct FramePacket
{
	char vectorram[1024];
	char frameno;  // wird bei jedem Frame inkrementiert
	char ping;     // Der Server schickt das letzte empfangene ping-Byte zurck
};

class KeysPacket
{
private:
	static const char KEY_HYPERSPACE = 1;
	static const char KEY_FIRE = 2;
	static const char KEY_THRUST = 4;
	static const char KEY_RIGHT = 8;
	static const char KEY_LEFT = 0x10;

	char signature[6];
	char keys;
public:
	char ping;     // wird vom Server bei nchster Gelegenheit zurckgeschickt. Fr Latenzmessung.

	KeysPacket(void);
	void clear(void);         // alle Tasten loslassen
	void hyperspace(bool b);  // Hyperspace drcken (true) oder loslassen (false)
	void fire(bool b);        // Feuerknopf drcken (true) oder loslassen (false)
	void thrust(bool b);      // Beschleunigen ...
	void right(bool b);       // rechts drehen ...
	void left(bool b);        // links drehen
};
#pragma pack()


class Player
{
public:
	Player(SOCKET sd, ADDRESS server_ip) : sd(sd), server_ip(server_ip){}
	void Run(void);
	void InterpretScreen(FramePacket &packet, GameStatus& game);
	void ReceivePacket(FramePacket &packet);
	void SendPacket(KeysPacket &packet);
private:
	SOCKET sd;
	ADDRESS server_ip;
};
