// player.h: Beispielspieler fr Asteroids
// Harald Bgeholz / c't
// weiterentwickelt von Marcus Brand
#ifndef PLAYER_H_INCLUDED
#define PLAYER_H_INCLUDED

#if defined(WINDOWS)
#define ADDRESS DWORD
#else
#define SOCKET int
#define ADDRESS in_addr_t
// 3 Includes fr sockaddr_in
#include <sys/types.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#endif

//#define SLT_INCL


class MyVektor;
class FlyingObj;

// global //////////////////////////////////////////////////////////////////////////////////////////////////
#define ARRAY_SIZE 256 // nicht mehr ndern! (oder InitShotMap ndern), sonst luft Feld ber

static const double DBL_MAX = 1.7976931348623158e+308;

static const int MAX_ASTEROIDS = 64; // 26 laut FAQ
static const int MAX_SHOTS = 8; // 6 laut FAQ

static const int MAX_TARGET_IND = MAX_ASTEROIDS * 8;
static const int MAX_SHOT_IND = MAX_SHOTS * 8;

// 2x66 scheint ein bischen wenig (noch ohne Sec. Target)
static const int CC_SIZE = 66; // Gre einer Kollisionsklasse (Radius des Rings) (gut bisher 66/3) 55/4
static const int CC_COUNT = 3; // die Anzahl der Ringe

static const int SLT = 67; //ShotLifeTime, wie lange rechne ich damit, fliegt ein Schuss
// so weit drehen, um zu prfen, ob er trifft 88(128 ansch. deutlich schlechter, 44 auch)
static const int TURNS_FOR_SHOOT_CALC = 88; 

static const float SHOT_CALC_STEP_WIDTH = 0.25;

static const char KEY_HYPERSPACE = 1;
static const char KEY_FIRE = 2;
static const char KEY_THRUST = 4;
static const char KEY_RIGHT = 8;
static const char KEY_LEFT = 0x10;

int norm256(int i);
int DoubleToInt(double d);
void Normalize(int &x, int &y);
void Normalize(double &x, double &y);
void NormPos(int &x, int &y);
double absSquare(const MyVektor &A, const MyVektor &B);
double Kreuzprodukt(const MyVektor &A, const MyVektor &B);
void printTarget(FlyingObj *pTarget);


class MyVektor
{
public:
	MyVektor::MyVektor() { x = 0.0; y = 0.0; }
	MyVektor::MyVektor(double dx, double dy) { x = dx; y = dy; Normalize(x, y); }
//	void NormVekt(double dx, double dy); // macht einen normierten Vektor draus

	double x;
	double y;
};

class FlyingObj
{
public:
	FlyingObj() { m_dDX = 0; m_dDY = 0; iHowExact = 0; m_iID = -1; }
	FlyingObj(int x, int y) { this->x = x; this->y = y; }
	virtual bool IsSaucer() = 0;
	virtual bool IsAsteroid() = 0;
	virtual bool IsShot() = 0;

	int x;    // Koordinaten des Mittelpunkts
	int y;
	double m_dDX;	// RichungsVektor
	double m_dDY;
	int iHowExact;
	int m_iID;
	int m_iSmallRadius; //todo berall benutzen
	int m_iBigRadius;
};

class CTarget : public FlyingObj
{
public:
	virtual bool IsBig() = 0;
	virtual bool IsMiddle() = 0;
	virtual bool IsSmall() = 0;

	int Mwt; // die Zeit, die ich warten muss, bevor ich drauf schiessen kann (MaxWaitTime)
	int nD; // die Anzahl der Drehungen, die ich machen muss, bevor ich drauf schiessen kann
	int TurnDir; // die Richtung, in die ich zum Zielen drehen muss
};

class Asteroid : public CTarget
{
public:
	void set(int x, int y, int type, int sf);

	bool IsSaucer() { return false; }
	bool IsAsteroid() { return true; }
	bool IsShot() { return false; }
	bool IsBig() { return sf == 0 ? true : false; }
	bool IsMiddle() { return sf == 15 ? true : false; }
	bool IsSmall() { return sf == 14 ? true : false; }

	int type; // 1 ... 4, uere Form
	int sf;   // scale factor: 0 = gro, 15 = mittel, 14 = klein

	// Kollisionsklasse, der dieser Asteroid angehrt (das wird wohl reichen, das fr Ast zu machen, sonst nach 
	// FlyingObj schieben)
	// 0 bis CC_COUNT-1: je kleiner, desto gefhrlicher, CC_COUNT: auerhalb dieser Klassen, 
	// CC_COUNT+1: klein und wurde schon drauf geschossen
	int m_iCC;
};

class Shot : public FlyingObj
{
public:
	// bei 2 als Maxtime fr WillCollide, wird er mit Rad 5 noch erwischt (?)
	Shot() { m_iSmallRadius = 0; m_iBigRadius = 1; }
	void set(int x, int y);

	bool IsSaucer() { return false; }
	bool IsAsteroid() { return false; }
	bool IsShot() { return true; }

//22.6. Shot.m_iTargetID gelscht	int m_iTargetID;
};

class MyShot // : public Shot
{
public:
	MyShot() { m_iID = -1; }

	int m_IndexWhenShot;
	int m_TimeFirstAppear;
	int x; // Koordinaten des SchiffsMittelpunkts, als geschossen wurde
	int y;
	int m_iID;
	int m_iTargetID;
	int m_iPrevMod;
};

class Ship : public FlyingObj
{
public:
	Ship() { m_iBigRadius = m_iSmallRadius = 12; }
	void set(int x, int y, int LookX, int LookY);

	bool IsSaucer() { return false; }
	bool IsAsteroid() { return false; }
	bool IsShot() { return false; }

	int m_LookX;        // Blickrichtung des Schiffes
	int m_LookY;
};

class Saucer : public CTarget
{
public:
	void set(int x, int y, int Size);

	bool IsSaucer() { return true; }
	bool IsAsteroid() { return false; }
	bool IsShot() { return false; }
	bool IsBig() { return m_Size == 15 ? true : false; }
	bool IsMiddle() { return false; }
	bool IsSmall() { return m_Size == 15 ? false : true; }

	int m_Size;    // Gre: 15 = gro, 14 = klein
};

class ShotMapEntry
{
public:
	ShotMapEntry() { m_Ship_LookX = 0; m_Ship_LookY = 0; m_xFirst = 0; m_yFirst = 0; m_dDX = 0.0; m_dDY = DBL_MAX; }

	int m_Ship_LookX;
	int m_Ship_LookY;
	int m_xFirst; // Position des 1. Schusses, relativ zum Schiffs-Mittelpunkt
	int m_yFirst;
	double m_dDX;	// RichungsVektor
	double m_dDY;
};

class GameStatus
{
public:
	GameStatus();
	void clear(void);

	bool ship_present;  // Schiff sichtbar
	Ship m_Ship;
/*	int ship_x;         // Mittelpunkt des Schiffs
	int ship_y;
	int ship_dx;        // Blickrichtung des Schiffes
	int ship_dy;*/
	bool saucer_present;// UFO sichtbar
	Saucer m_Saucer;
/*	int saucer_x;       // Mittelpunkt des UFOs
	int saucer_y;
	int saucer_size;*/    // Gre: 15 = gro, 14 = klein
	int nasteroids; // Anzahl Asteroiden
	Asteroid asteroids[MAX_ASTEROIDS];
	int nshots;     // Anzahl Schsse
	Shot shots[MAX_SHOTS];
	int m_iShotMapPos;
	int m_iShotMapModify;
	bool m_bFire;
};

#pragma pack(1)
struct FramePacket
{
	char vectorram[1024];
	char frameno;  // wird bei jedem Frame inkrementiert
	char ping;     // Der Server schickt das letzte empfangene ping-Byte zurck
};

class KeysPacket
{
private:
	char signature[6];
	char keys;
public:
	char ping;     // wird vom Server bei nchster Gelegenheit zurckgeschickt. Fr Latenzmessung.

	KeysPacket(void);
	void clear(void);         // alle Tasten loslassen
	void setPacket(char SetKeys) { keys = SetKeys; }
	// auskommentiert, gefllt mir besser: eigenen char setzen und am Ende ans KeysPacket bergeben
/*	void hyperspace(bool b);  // Hyperspace drcken (true) oder loslassen (false)
	void fire(bool b);        // Feuerknopf drcken (true) oder loslassen (false)
	void thrust(bool b);      // Beschleunigen ...
	void right(bool b);       // rechts drehen ...
	void left(bool b);        // links drehen
	*/
};
#pragma pack()


class Player
{
public:
	Player(SOCKET sd, ADDRESS server_ip);
	void Run(void);
	void InterpretScreen(FramePacket &packet);
	void ReceivePacket(FramePacket &packet);
	void SendPacket(KeysPacket &packet);
	void InitShotMap();
	bool CheckAndDoFire(int CCFound);
	void TurnLeft();
	void TurnRight();
	void Shoot(FlyingObj *pTarget);
#ifdef SLT_INCL
	void CalcShot(FlyingObj *pTarget, int iShotIndex, double &DistMin, int iTimeToTurn, int iRadius, int &iHit);
#else
	void CalcShot(FlyingObj *pTarget, int iShotIndex, double &DistMin, int iTimeToTurn);
#endif
	void SetSaucerVektor();
	void SetAsteroidVektoren();
	void SetShotVektoren();
	void SetShipVektor();
	void CalcStatVirt();
	void CompareShotsAndCorrectMap();
	bool NeedToJump();
	void UpdateMyShots();
	bool WillCollide(FlyingObj &ObjStand, FlyingObj &ObjMove, int iRadius, int iMinTime, int iMaxTime);
	void ReduceCC();
	bool WasShotAt(CTarget &Obj);
	void InitStatCur();
	bool CalcTimeToShoot(int iRadius, int &iStep, double &dDiffM, double &dDiffR, double &dDiffL, FlyingObj *pTarget,
		int iMaxStep);
	void CenterBackOfShip();
	void resetMyShots();
	int SetCollClasses();

private:
	SOCKET sd;
	ADDRESS server_ip;
	//MB
	int t;
	GameStatus m_StatPrev;
	GameStatus m_StatCur;
	GameStatus m_StatVirt;

	CTarget *m_pPrimTarget;
	ShotMapEntry m_ShotMap[ARRAY_SIZE];

	char m_Keys;
	int m_iPrevPrevMod;
	MyShot m_MyShots[4];
	int m_nMyShots;
	int m_iNextShotInd;
	int m_iNextTargetInd;
	// m_iCCMin brauche ich wohl nicht (ausser, wenn Berechnung in jedem Zug zu aufwndig)
	int m_iCCMin; // die gerade kleinste Kollisionsklasse, wird nach CC_SIZE Frames um 1 reduziert
	int m_iCCReduce; // wenn der auf 0, wird er auf CC_SIZE gesetzt und m_iCCMin reduziert
	int m_iMaxSlt;
	int m_iMaxTurns;
	int m_CCSize;
	int m_CCCount;
	int m_nLostFrames;
};

#endif //#ifndef PLAYER_H_INCLUDED
