// connection.cpp: Beispielspieler fr Asteroids (Verbindung zu Mame)
// Harald Bgeholz / c't; Umstrukturierung Matthias Fuchs

#include <errno.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>

#if defined(WINDOWS) || defined(_WIN32)
#else
// 2 Includes fr socket()
#include <sys/types.h>
#include <sys/socket.h>
// 2 Includes fr inet_addr()
#include <netinet/in.h>
#include <arpa/inet.h>
// 2 Includes fr fcntl()
#include <unistd.h>
#include <fcntl.h>
// fr memset()
#define INVALID_SOCKET -1
#define WSAGetLastError() errno
#endif

#include "connection.h"


KeysPacket::KeysPacket(void)
{
   signature[0] = 'c';
   signature[1] = 't';
   signature[2] = 'm';
   signature[3] = 'a';
   signature[4] = 'm';
   signature[5] = 'e';
   keys = '@';
   ping = 0;
}

void KeysPacket::clear(void)
{
   keys = '@';
}

void KeysPacket::hyperspace(bool b)
{
   if (b)
      keys |= KEY_HYPERSPACE;
   else
      keys &= ~KEY_HYPERSPACE;
}

void KeysPacket::fire(bool b)
{
   if (b)
      keys |= KEY_FIRE;
   else
      keys &= ~KEY_FIRE;
}

void KeysPacket::thrust(bool b)
{
   if (b)
      keys |= KEY_THRUST;
   else
      keys &= ~KEY_THRUST;
}

void KeysPacket::left(bool b)
{
   if (b)
   {
      keys |= KEY_LEFT;
      right(false);
   }
   else
      keys &= ~KEY_LEFT;
}

void KeysPacket::right(bool b)
{
   if (b)
   {
      keys |= KEY_RIGHT;
      left(false);
   }
   else
      keys &= ~KEY_RIGHT;
}

Connection::Connection (const char* server_ip_str)
{
   server_ip = inet_addr(server_ip_str);
   if (server_ip == INADDR_NONE)
   {
      fprintf(stderr, "Ungueltige IP-Adresse: '%s'\n", server_ip_str);
      exit(1);
   }

#if defined(WINDOWS) || defined(_WIN32)
   WSADATA wsadata;
   if (WSAStartup(MAKEWORD(2,2), &wsadata))
   {
      fprintf(stderr, "Fehler beim Initialisieren von Winsock.\n");
      exit(2);
   }
#endif

   sd = socket(AF_INET, SOCK_DGRAM, 0);
   if (sd == INVALID_SOCKET)
   {
      fprintf(stderr, "Fehler %d bei socket().\n", WSAGetLastError());
      exit(2);
   }

#if defined(WINDOWS) || defined(_WIN32)
   unsigned long enable_nonblocking = 1;
   if (ioctlsocket(sd, FIONBIO, &enable_nonblocking))
   {
      fprintf(stderr, "Kann Socket nicht auf nonblocking setzen (%d)", WSAGetLastError());
      exit(1);
   }
#else
    if (-1 == fcntl(sd, F_SETFL, O_NONBLOCK))
    {
        perror("Kann Socket nicht auf non-blocking setzen");
        exit(1);
    }
#endif
   sockaddr_in sa;
   memset(&sa, 0, sizeof sa);
   sa.sin_family = AF_INET;
   sa.sin_addr.s_addr = 0;
   sa.sin_port = 0;

   if (bind(sd, (struct sockaddr*) &sa, sizeof sa))
   {
      fprintf(stderr, "Fehler %d bei bind().\n", WSAGetLastError());
      exit(2);
   }
}

void Connection::ReceivePacket(FramePacket &packet)
{
   sockaddr_in sender;
   // int sender_size = sizeof sender;
   fd_set readfds, writefds, exceptfds;

   do
   {
      FD_ZERO(&readfds);
      FD_ZERO(&writefds);
      FD_ZERO(&exceptfds);
      FD_SET(sd, &readfds);
      FD_SET(sd, &exceptfds);
      select(sd+1, &readfds, &writefds, &exceptfds, NULL);
      int bytes_received = recv(sd, (char *)&packet, sizeof packet, 0);
      if (bytes_received != (int)sizeof packet)
      {
         int err = WSAGetLastError();
         fprintf(stderr, "Fehler %d bei recvfrom().\n", err);
         exit(1);
      }
      FD_ZERO(&readfds);
      FD_ZERO(&writefds);
      FD_ZERO(&exceptfds);
      FD_SET(sd, &readfds);
      timeval zero;
      zero.tv_sec = zero.tv_usec = 0;
      select(sd+1, &readfds, &writefds, &exceptfds, &zero);
   } while(FD_ISSET(sd, &readfds));
}

void Connection::SendPacket(const KeysPacket &packet)
{
   sockaddr_in server;
   memset(&server, 0, sizeof server);
   server.sin_family = AF_INET;
   server.sin_port = htons(1979);
   server.sin_addr.s_addr = server_ip;
   if ((int)sizeof packet != sendto(sd, (char *)&packet, sizeof packet, 0, (sockaddr*)&server, sizeof server))
   {
#if defined(WINDOWS) || defined(_WIN32)
      int err = WSAGetLastError();
      if (err != WSAEWOULDBLOCK)
      {
         fprintf(stderr, "Fehler %d bei sendto().\n", err);
         exit(1);
      }
#else
      if (errno != EAGAIN)
      {
         perror("Fehler bei sendto()");
         exit(1);
      }
#endif
   }
}
