/*
 * Decompiled with CFR 0.152.
 */
package de.caff.asteroid;

import de.caff.asteroid.Asteroid;
import de.caff.asteroid.Bullet;
import de.caff.asteroid.FrameInfo;
import de.caff.asteroid.FramePreparer;
import de.caff.asteroid.MovingGameObject;
import de.caff.asteroid.SpaceShip;
import de.caff.asteroid.Ufo;
import de.caff.util.Pair;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleVelocityPreparer
implements FramePreparer {
    private static final int MAX_SQUARED_ASTEROID_VELOCITY = 36;
    protected static final int MAX_SQUARED_BULLET_VELOCITY = 256;

    protected void prepareUfo(LinkedList<FrameInfo> frameInfos, FrameInfo prevFrame, FrameInfo currFrame) {
        Ufo ufo = currFrame.getUfo();
        if (ufo != null) {
            ufo.setVelocityFromDelta(prevFrame.getUfo());
        }
    }

    protected void prepareSpaceShip(LinkedList<FrameInfo> frameInfos, FrameInfo prevFrame, FrameInfo currFrame) {
        SpaceShip ship = currFrame.getSpaceShip();
        if (ship != null) {
            ship.setVelocityFromDelta(prevFrame.getSpaceShip());
        }
    }

    protected void prepareAsteroids(LinkedList<FrameInfo> frameInfos, FrameInfo prevFrame, FrameInfo currFrame) {
        AsteroidSelector selector = new AsteroidSelector(currFrame.getAsteroids());
        for (Asteroid ast : prevFrame.getAsteroids()) {
            Asteroid candidate = selector.getBestMatch(ast);
            if (candidate == null) continue;
            candidate.setVelocityFromDelta(ast);
            candidate.inheret(ast);
        }
    }

    protected void prepareBullets(LinkedList<FrameInfo> frameInfos, FrameInfo prevFrame, FrameInfo currFrame) {
        for (Bullet oldBullet : prevFrame.getBullets()) {
            double futureX = (double)oldBullet.getX() + oldBullet.getVelocityX();
            double futureY = (double)oldBullet.getY() + oldBullet.getVelocityY();
            TreeMap<Double, Pair<Bullet>> result = new TreeMap<Double, Pair<Bullet>>();
            for (Bullet bullet : currFrame.getBullets()) {
                double dist2 = bullet.getSquaredDistance(futureX, futureY);
                if (!(dist2 < 256.0)) continue;
                result.put(dist2, new Pair<Bullet>(oldBullet, bullet));
            }
            LinkedList pairs = new LinkedList(result.values());
            while (!pairs.isEmpty()) {
                Pair pair = (Pair)pairs.remove(0);
                ((Bullet)pair.second).setVelocityFromDelta((MovingGameObject)pair.first);
                ((Bullet)pair.second).inheret((MovingGameObject)pair.first);
                ListIterator it = pairs.listIterator();
                while (it.hasNext()) {
                    Pair p = (Pair)it.next();
                    if (!((Bullet)p.first).equals(pair.first) && !((Bullet)p.second).equals(pair.second)) continue;
                    it.remove();
                }
            }
        }
    }

    protected void prepareSingleFrame(FrameInfo frame) {
        for (Bullet bullet : frame.getBullets()) {
            bullet.setLifetime(1);
        }
    }

    @Override
    public void prepareFrames(LinkedList<FrameInfo> frameInfos) {
        if (frameInfos.size() >= 2) {
            FrameInfo currFrame = frameInfos.getLast();
            FrameInfo prevFrame = frameInfos.get(frameInfos.size() - 2);
            this.prepareUfo(frameInfos, prevFrame, currFrame);
            this.prepareSpaceShip(frameInfos, prevFrame, currFrame);
            this.prepareAsteroids(frameInfos, prevFrame, currFrame);
            this.prepareBullets(frameInfos, prevFrame, currFrame);
        } else if (!frameInfos.isEmpty()) {
            this.prepareSingleFrame(frameInfos.getLast());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class AsteroidSelector {
        private Map<Key, List<Asteroid>> sorted = new HashMap<Key, List<Asteroid>>();

        public AsteroidSelector(Collection<Asteroid> asteroids) {
            for (Asteroid ast : asteroids) {
                Key key = new Key(ast);
                List<Asteroid> list = this.sorted.get(key);
                if (list == null) {
                    list = new LinkedList<Asteroid>();
                    this.sorted.put(key, list);
                }
                list.add(ast);
            }
        }

        public Asteroid getBestMatch(Asteroid asteroid) {
            Asteroid nearest;
            block3: {
                double minDist2;
                List<Asteroid> list;
                block4: {
                    block5: {
                        Key key = new Key(asteroid);
                        list = this.sorted.get(key);
                        minDist2 = 36.0;
                        nearest = null;
                        if (list == null || list.isEmpty()) break block3;
                        if (asteroid.getVelocityX() != 0.0 || asteroid.getVelocityY() != 0.0) break block4;
                        if (list.size() != 1 || list.get(0).getSquaredDistance(asteroid) > 36) break block5;
                        nearest = list.get(0);
                        break block3;
                    }
                    LinkedList<Asteroid> possibleCandidates = new LinkedList<Asteroid>();
                    for (Asteroid a : list) {
                        if (a.getIdentity() != null || a.getSquaredDistance(asteroid) > 36) continue;
                        possibleCandidates.add(a);
                    }
                    if (possibleCandidates.isEmpty()) break block3;
                    if (possibleCandidates.size() > 1) {
                        Collections.sort(possibleCandidates, new Comparator<Asteroid>(){

                            @Override
                            public int compare(Asteroid o1, Asteroid o2) {
                                return o1.getIndex() - o2.getIndex();
                            }
                        });
                    }
                    nearest = (Asteroid)possibleCandidates.get(0);
                    break block3;
                }
                double futureX = (double)asteroid.getX() + asteroid.getVelocityX();
                double futureY = (double)asteroid.getY() + asteroid.getVelocityY();
                for (Asteroid a : list) {
                    double dist2 = a.getSquaredDistance(futureX, futureY);
                    if (!(dist2 < minDist2)) continue;
                    nearest = a;
                    minDist2 = dist2;
                }
            }
            return nearest;
        }

        private static class Key {
            private final int type;
            private final int size;

            private Key(Asteroid ast) {
                this.type = ast.getType();
                this.size = ast.getSize();
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                Key key = (Key)o;
                if (this.size != key.size) {
                    return false;
                }
                return this.type == key.type;
            }

            public int hashCode() {
                int result = this.type;
                result = 31 * result + this.size;
                return result;
            }
        }
    }
}

