/*
 * Decompiled with CFR 0.152.
 */
package de.caff.asteroid;

import de.caff.asteroid.FrameInfo;
import de.caff.asteroid.FrameListener;
import de.caff.asteroid.GameData;

public class TimedScorePrinter
implements FrameListener,
GameData {
    public static final int DEFAULT_FRAMES = 18000;
    public static final int NO_FRAME = -1;
    private int startFrame = -1;
    private final int countFrames;
    private int score = 0;

    public TimedScorePrinter() {
        this(18000);
    }

    public TimedScorePrinter(int frames) {
        this.countFrames = frames;
    }

    public void frameReceived(FrameInfo frame) {
        if (!frame.isGameRunning()) {
            this.startFrame = -1;
        } else if (this.startFrame == -1) {
            if (frame.getSpaceShip() != null) {
                this.startFrame = frame.getIndex();
            }
        } else if ((frame.getIndex() - this.startFrame) % this.countFrames == 0) {
            this.score = frame.getScore();
            int frames = frame.getIndex() - this.startFrame;
            int seconds = frames / 60;
            System.out.println(String.format("Score after %5d frames (%02d:%02d):\t%d", frames, seconds / 60, seconds % 60, this.score));
        }
    }

    public int getLatestScore() {
        return this.score;
    }
}

