/*
 * Decompiled with CFR 0.152.
 */
package de.caff.asteroid.rammi;

import de.caff.asteroid.Bullet;
import de.caff.asteroid.FrameInfo;
import de.caff.asteroid.GameData;
import de.caff.asteroid.GameObject;
import de.caff.asteroid.SimpleVelocityPreparer;
import de.caff.asteroid.SpaceShip;
import de.caff.asteroid.analysis.DumpFile;
import de.caff.asteroid.analysis.FrameKeyInfo;
import de.caff.util.Tools;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;

public class Extract
implements GameData {
    private static final Point SHIP_POS = new Point(524, 524);

    public static void main(String[] args) {
        Locale.setDefault(Locale.US);
        BulletLane[] lanes = new BulletLane[256];
        for (int k = -256; k <= 256; ++k) {
            int index;
            BulletLane result = Extract.readFile(String.format("dir-dump/dir.%d.dump", k));
            if (result == null) {
                System.err.println(String.format("%-3d: no result!", k));
                continue;
            }
            for (index = k; index < 0; index += 256) {
            }
            if (lanes[index %= 256] == null) {
                lanes[index] = result;
                continue;
            }
            if (lanes[index].equals(result)) continue;
            System.err.println(String.format("%-3d: Mismatch!", k));
        }
        for (BulletLane l : lanes) {
            System.out.println(String.format("new Direction(%d, %d, %1.3f, %1.3f, %d, %d),", l.getStartDir().x, l.getStartDir().y, l.getVelocity().getX(), l.getVelocity().getY(), l.getFirstDelta().x, l.getFirstDelta().y));
        }
    }

    private static BulletLane readFile(String filename) {
        try {
            DumpFile file = new DumpFile(filename);
            file.runPreparerDirectly(new SimpleVelocityPreparer());
            LinkedList<BulletLane> flying = new LinkedList<BulletLane>();
            Point startDir = null;
            BulletLane result = null;
            boolean count = false;
            for (FrameKeyInfo info : file.getInfos()) {
                SpaceShip ship;
                FrameInfo frameInfo = info.getFrameInfo();
                for (Bullet bullet : frameInfo.getBullets()) {
                    if (bullet.getLifetime() <= 0 && startDir != null && Tools.getDistance(bullet.getLocation(), SHIP_POS) < 25.0) {
                        flying.add(new BulletLane(startDir, bullet));
                        startDir = null;
                        continue;
                    }
                    if (bullet.getLifetime() > 8) continue;
                    boolean found = false;
                    for (BulletLane bl : flying) {
                        Bullet last;
                        if (bl.getLastFramesBullet().getLifetime() != bullet.getLifetime() - 1 || !(Tools.getLength(GameObject.getTorusDelta(bl.getLastFramesBullet().getLocation(), bullet.getLocation())) <= 10.0) || (last = bl.getLastFramesBullet()).getLifetime() > 0 && Tools.getLength(GameObject.getTorusDelta(last.getNextLocation(), bullet.getLocation())) > 4.0) continue;
                        if (bl.addBullet(bullet)) {
                            double angle = 57.29577951308232 * Math.atan2(bl.getVelocity().getY(), bl.getVelocity().getX());
                            if (angle < 0.0) {
                                angle += 360.0;
                            }
                            flying.remove(bl);
                            result = bl;
                        }
                        found = true;
                        break;
                    }
                    if (found) continue;
                    System.out.println("Not found: " + bullet + " in frame " + frameInfo.getIndex());
                }
                List<FrameKeyInfo.ButtonInfo> buttonList = info.getButtons();
                if (buttonList.isEmpty() || (buttonList.get(0).getButtons().getKeys() & 2) == 0 || (ship = frameInfo.getSpaceShip()) == null) continue;
                if (startDir != null) {
                    System.out.println("*** STARTDIR in frame " + frameInfo.getIndex());
                }
                startDir = ship.getDirection();
            }
            return result;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    private static class BulletLane {
        private final Point startDir;
        private Bullet lastFramesBullet;
        private Point firstDelta;
        private Point velocity;

        private BulletLane(Point startDir, Bullet bullet) {
            this.startDir = new Point(startDir);
            this.firstDelta = GameObject.getTorusDelta(bullet.getLocation(), SHIP_POS);
            this.lastFramesBullet = bullet;
            this.velocity = new Point();
        }

        public boolean addBullet(Bullet bullet) {
            this.lastFramesBullet = bullet;
            this.velocity.x = (int)((double)this.velocity.x + bullet.getVelocityX());
            this.velocity.y = (int)((double)this.velocity.y + bullet.getVelocityY());
            return bullet.getLifetime() == 8;
        }

        public Bullet getLastFramesBullet() {
            return this.lastFramesBullet;
        }

        public Point2D getVelocity() {
            return new Point2D.Double(this.velocity.getX() / 8.0, this.velocity.getY() / 8.0);
        }

        public Point getStartDir() {
            return this.startDir;
        }

        public Point getFirstDelta() {
            return this.firstDelta;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BulletLane that = (BulletLane)o;
            if (!this.firstDelta.equals(that.firstDelta)) {
                return false;
            }
            if (!this.startDir.equals(that.startDir)) {
                return false;
            }
            return this.velocity.equals(that.velocity);
        }

        public int hashCode() {
            int result = this.startDir.hashCode();
            result = 31 * result + this.firstDelta.hashCode();
            result = 31 * result + this.velocity.hashCode();
            return result;
        }
    }
}

