/*
 * Decompiled with CFR 0.152.
 */
package de.caff.gimmicks.swing;

import de.caff.gimmicks.swing.AbstractState;
import de.caff.gimmicks.swing.State;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class StateManager
implements PropertyChangeListener {
    private List stateList = new LinkedList();
    private AbstractState activeState;

    public void addState(AbstractState state) {
        state.setManager(this);
        this.stateList.add(state);
        if (this.activeState == null) {
            state.activate();
            this.activeState = state;
        } else {
            this.setActiveState(state);
        }
        state.addPropertyChangeListener(this);
    }

    void setActiveState(AbstractState state) {
        if (this.activeState != state) {
            if (this.stateList.contains(state)) {
                if (this.activeState != null) {
                    this.activeState.deactivate();
                }
                this.activeState = state;
            } else {
                throw new RuntimeException("Trying to activate unregistered state");
            }
        }
    }

    public List getStates() {
        return Collections.unmodifiableList(this.stateList);
    }

    public State getActiveState() {
        return this.activeState;
    }

    boolean mayActivate(AbstractState state) {
        if (this.stateList.contains(state)) {
            return state.isEnabled();
        }
        throw new RuntimeException("Trying to access unregistered state");
    }

    boolean mayEnable(AbstractState state, boolean enable) {
        return enable || this.getFirstEnabledState(state) != null;
    }

    protected AbstractState getFirstEnabledState(AbstractState ignore) {
        for (AbstractState state : this.stateList) {
            if (state == ignore || !state.isEnabled()) continue;
            return state;
        }
        return null;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        AbstractState state = (AbstractState)evt.getSource();
        if ("ACTIVATION".equals(evt.getPropertyName())) {
            if (((Boolean)evt.getNewValue()).booleanValue()) {
                this.setActiveState(state);
            }
        } else if ("ENABLE".equals(evt.getPropertyName()) && !((Boolean)evt.getNewValue()).booleanValue() && this.activeState == state) {
            this.getFirstEnabledState(state).activate();
        }
    }
}

