/*
 * Decompiled with CFR 0.152.
 */
package de.caff.i18n.swing;

import de.caff.i18n.I18n;
import java.util.Locale;
import java.util.MissingResourceException;
import javax.swing.AbstractButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

class I18nHelper {
    I18nHelper() {
    }

    public static void setProperties(JMenuItem menuItem, String tag, Locale locale) {
        I18nHelper.setProperties((AbstractButton)menuItem, tag, locale);
        try {
            menuItem.setAccelerator(KeyStroke.getKeyStroke(I18n.getString(tag + "-ACCEL", locale)));
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
    }

    public static void setProperties(AbstractButton button, String tag, Locale locale) {
        button.setText(I18n.getString(tag + "-TEXT", locale));
        try {
            button.setToolTipText(I18n.getString(tag + "-TTT", locale));
        }
        catch (MissingResourceException e) {
            // empty catch block
        }
        try {
            button.setMnemonic(I18n.getString(tag + "-MNEMO", locale).charAt(0));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void setProperties(JLabel button, String tag, Locale locale) {
        button.setText(I18n.getString(tag + "-TEXT", locale));
        try {
            button.setToolTipText(I18n.getString(tag + "-TTT", locale));
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
    }
}

