/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util.settings;

import de.caff.i18n.I18n;
import de.caff.util.settings.EnumValue;
import java.util.Locale;
import java.util.prefs.Preferences;

public class LocaleEnumValue
implements EnumValue {
    private final Locale locale;

    public LocaleEnumValue(Locale locale) {
        this.locale = locale;
    }

    public String getShortName(Locale l) {
        return this.locale == null ? I18n.getString("localeDefault", l) : this.locale.getDisplayName(l);
    }

    public String getLongName(Locale l) {
        return null;
    }

    public void storeTo(Preferences preferences, String key) {
        if (this.locale == null) {
            preferences.remove(key);
        } else {
            preferences.put(key, this.locale.toString());
        }
    }

    public boolean isEqualTo(Preferences preferences, String key) {
        String value = preferences.get(key, null);
        return this.locale == null && value == null || this.locale != null && this.locale.toString().equals(value);
    }

    public Object getRealValue() {
        return this.locale;
    }

    public Locale getLocale() {
        return this.locale;
    }
}

