/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util.settings.swing;

import de.caff.util.settings.swing.AbstractBasicEditorProvider;
import de.caff.util.settings.swing.SwingDirectoryPreferenceProperty;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Locale;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;

class DirectoryEditor
extends AbstractBasicEditorProvider
implements PropertyChangeListener {
    private final SwingDirectoryPreferenceProperty property;
    private final Box box = Box.createHorizontalBox();
    private final JLabel label;
    private final JButton button;
    private File directory;

    public DirectoryEditor(SwingDirectoryPreferenceProperty prop, final Locale l) {
        super(prop, l);
        this.property = prop;
        this.directory = this.property.getDirectory();
        this.label = new JLabel(this.directory.getPath());
        this.button = new JButton("...");
        this.button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JFileChooser chooser = new JFileChooser(DirectoryEditor.this.directory);
                chooser.setFileSelectionMode(1);
                chooser.setDialogTitle(DirectoryEditor.this.property.getName(l));
                if (chooser.showSaveDialog(DirectoryEditor.this.button) == 0) {
                    DirectoryEditor.this.setDirectory(chooser.getSelectedFile());
                }
            }
        });
        this.box.add(this.label);
        this.box.add(Box.createHorizontalGlue());
        this.box.add(this.button);
        this.property.addValueChangeListener(this);
    }

    private void setDirectory(File dir) {
        this.directory = dir;
        this.label.setText(dir == null ? "" : dir.getPath());
    }

    public JComponent getEditor() {
        return this.box;
    }

    public void reset() {
        this.setDirectory(this.property.getDirectory());
    }

    public void save() {
        this.property.setDirectory(this.directory);
    }

    public void goodBye() {
        this.property.removeValueChangeListener(this);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this.setDirectory((File)evt.getNewValue());
    }
}

