// ============================================================================
// File:               $File$
//
// Project:            
//
// Purpose:            
//
// Author:             Rammi
//
// Copyright Notice:   (c) 2008  Rammi (rammi@caff.de)
//
// Latest change:      $Date$
//
// History:	       $Log$
//=============================================================================
package de.caff.asteroid.analysis.statistics;

import de.caff.asteroid.PropertyProvider;
import de.caff.asteroid.analysis.FrameKeyInfo;

import java.util.Collection;

/**
 *  Create a statistics from a bunch of frames.
 */
public interface DumpFileStatistics
        extends PropertyProvider
{
  /**
   *  Analyse the frames.
   *  @param infos frame key infos to analyse
   */
  public void analyse(Collection<FrameKeyInfo> infos);

  /**
   *  Get a title for this statistics.
   *  @return statistics title
   */
  public String getTitle();

  /**
   *  Return a complete html document containing a summary report for the data from the lastest analysis.
   *  @return summary report in HTML format
   */
  public String getHtmlReport();

  /**
   *  Append the summary report of this statistics to the document.
   *  @param html HTML document to which the report is added
   */
  public void appendToHtml(StringBuilder html);

  /**
   *  Does this statistic need prepared frames?
   *  @return the answer
   */
  public boolean needPreparation();
}
