#include <sys/time.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <stdio.h>
#include <stdlib.h>
#include <iostream>
#include <fstream>

#include "agent.h"
#include "g_state.h"
#include "consts.h"
#include <sstream>
#include <queue>
#include <map>

using namespace std;

extern bool contest_run;
extern bool dump;
extern bool verbose;
extern bool auto_start;

string seconds_to_string(int seconds)
{	int days=seconds/(24*60*60);
	seconds-=days*24*60*60;
	int hours=seconds/(60*60);
	seconds-=hours*60*60;
	int min=seconds/60;
	seconds-=min*60;
	ostringstream o;
	if (days) o << days << "d";
	if (hours) o << hours << "h";
	if (min) o << min << "m";
	o << seconds << "s";
	return o.str();
}

agent::agent(int sock,unsigned long sip)
{	sd=sock;
	server_ip=sip;
}	

void agent::run()
{	packet_frame	frame;
	packet_keys	keys;
	g_state	game;

	int	frame_nr=0;
	bool	game_running=false;
	int	latency=0;
	bool	last_frame_shot=false;
	int	wave=0;
	int	wave_frame=false;
	bool	asteroids_present=false;
	int	score_overflow=0;
	int	last_score=0;
	unsigned char ship_rotation_byte_1=0;
	bool	alive=false;;
	bool	in_hyperspace=false;
	int	death_count=0;

	ofstream	out_vram;
	ofstream	out_dump;
	if (dump)
	{	out_vram.open("all_dump/vram");
		out_dump.open("all_dump/dumps");
	}

	while (true)
	{	keys.ping++;
		send(keys);
		receive(frame);
		keys.clear();

		frame_nr++;
		wave_frame++;
		latency=0;
		
		if (frame.ping != keys.ping)
		{	//cout << "Latenz " << keys.ping - frame.ping << endl;
			latency=keys.ping - frame.ping;
		}

		game.interpret(frame.vram,latency);
		game.compute_targets();

		if (dump && game_running)
		{	for (int l=0; l<1024; ++l)
				out_vram << frame.vram[l];
			out_dump << "frame_nr " << frame_nr << endl;
			out_dump << game << endl;
		}


		ofstream out("all_dump/dump");
		out << game;
		out.close();

		// higscore input
		if (game.message.find("IHR ERGEBNIS")!=string::npos)
		{	string	hs(game.message.substr(143,3));
			if (hs[2]=='S')
			{	keys.hyperspace(true);
			}
			else if (hs[1]=='L' && (hs[2]<'A' || hs[2]>'Z'))
			{	keys.hyperspace(true);
			}	
			else if(hs[0] =='N' && (hs[1]<'A' || hs[1]>'Z'))
			{	keys.hyperspace(true);
			}	
			if (!keys.hyperspace())
			{	keys.left(true);
			}
		}	
		if (auto_start && string::npos!=game.message.find("STARTKNOEPFE DRUECKEN"))
		{	keys.start(true);
			frame_nr=0;
			death_count=0;
		}
		if ((contest_run && frame_nr==18000) || (game_running && string::npos!=game.message.find("SPIELENDE")))
		{	int real_score=score_overflow*100000+game.score;
			if (verbose) cout << "score " << real_score << " in " << frame_nr;
			double score_per_frame=double(real_score)/(double(frame_nr));
			if (verbose) cout << " " << score_per_frame << " spf ";
			if (verbose) cout << "in wave " << wave;
			if (verbose) cout << " " << death_count << " deaths";
			if (verbose) cout << endl;
			game_running=false;
			if (contest_run)
				exit(0);
		}
		if (game_running)
		{	// wave start detection
			if (!asteroids_present && game.asteroids.size())
			{	asteroids_present=true;
				wave++;
				wave_frame=0;
			}
			// wave clear detection
			if (asteroids_present && game.asteroids.size()==0)
			{	asteroids_present=false;
				int real_score=score_overflow*100000+game.score;
				if (verbose) cout << "wave " << wave << " cleared in " << wave_frame << " " << real_score << " ";
				if (verbose) cout << "game " << frame_nr << " " << double(real_score)/(double(frame_nr)) << " spf" << endl;

			}
		}
		if (game.ship_present)
		{	alive=true;
			in_hyperspace=false;
			if (!game_running)
			{	wave=0;
				asteroids_present=false;
				score_overflow=0;
				last_score=0;
				game.ship_rotation_byte=0;
				frame_nr=1;
			}	
			game_running=true;
			if (last_score>game.score)
			{	score_overflow++;
			}
			last_score=game.score;


			// check & resync shot direction
			double ship_pic_dir=atan2(game.ship.pic_dir.y,game.ship.pic_dir.x);
			pair<int,int>	range(get_best_mapping(ship_pic_dir));
			unsigned char diff=game.ship_rotation_byte-ship_rotation_byte_1;
			if (range.first<range.second)
			{	if (ship_rotation_byte_1 < range.first)
				{
//cout << "resync 1 " << int(ship_rotation_byte_1) << " -> ";
					game.ship_rotation_byte=range.first+diff;
//cout << int(ship_rotation_byte) << endl;				
				}
				else if (ship_rotation_byte_1 > range.second)
				{
//cout << "resync 2 " << int(ship_rotation_byte_1) << " -> ";
					game.ship_rotation_byte=range.second+diff;
//cout << int(ship_rotation_byte) << endl;				
				}
			}	
			else	
			{	if (ship_rotation_byte_1<range.first && ship_rotation_byte_1>range.second)
				{
//cout << "resync 3 " << int(ship_rotation_byte_1) << " -> ";
					game.ship_rotation_byte=diff;
//cout << int(ship_rotation_byte) << endl;				
				}
			}
			ship_rotation_byte_1=game.ship_rotation_byte;

			p2d	new_shot_dir(wb_to_dir(game.ship_rotation_byte));
			
			// rotation
			if (game.targets.size())
			{	target	t(game.targets.begin()->second);

				double	th=get_required_time(game.ship.pos,t.pos,t.dir);
				p2d	i((t.pos+t.dir*th)-game.ship.pos);
				
				if (new_shot_dir.x*i.y - new_shot_dir.y*i.x > 0)
				{	keys.left(true);
					game.ship_rotation_byte+=3;
				}	
				else
				{	keys.right(true);
					game.ship_rotation_byte-=3;
				}	


			}	
			if (!game.saucer_present && game.asteroids.size()==0)
			{	// point upward
				if (game.ship_rotation_byte<63)
					keys.left(true);
				else
					keys.right(true);
			}

			// shooting
			if (last_frame_shot)
			{	last_frame_shot=false;
			}
			else
			{	for (map<double,target>::iterator i=game.targets.begin(); i!=game.targets.end(); ++i)
				{	double ht=get_required_time(game.ship.pos,i->second.pos,i->second.dir);
					double d=get_distance_at_t(ht,game.ship.pos,new_shot_dir,i->second.pos,i->second.dir);
					if (ht>0.0 && ht<MAX_SHOT_FRAMES && d<i->second.radius)
					{	keys.fire(true);
						last_frame_shot=true;
//cout << "shot at " << i->second << " ship_pos=" << game.ship.pos << " shot_dir=" << new_shot_dir << endl;						
						i->second.source->shot_at=QUEUE_SIZE;
						i->second.source->count_shots++;
						break;
					}
//break;					
				}	
			}
		}
		else // !game.ship_present
		{	if (alive && !in_hyperspace)
			{	if (verbose) cout << "death frame_nr " << frame_nr << endl;
				death_count++;
			}
			alive=false;
		}
	}
}

void agent::send(packet_keys &keys)
{	sockaddr_in server;
	memset(&server,0,sizeof(server));
	server.sin_family=AF_INET;
	server.sin_port=htons(1979);
	server.sin_addr.s_addr=server_ip;
	int ret=sendto(sd,(unsigned char*)&keys,sizeof(keys),0,(sockaddr*)&server,sizeof(server));
	if (sizeof(keys)!=ret)
	{	perror("agent::send sendto() :");
		exit(11);
	}
}	

void agent::receive(packet_frame &frame)
{	fd_set	readfds;
	do
	{	FD_ZERO(&readfds);
		FD_SET(sd,&readfds);
		select(sd+1,&readfds,NULL,NULL,NULL);
		int ret=recv(sd,(unsigned char*)&frame,sizeof(frame),0);
		if (ret==-1)
		{	perror("agent::receive: select: ");
		}
		else if (ret!=sizeof(frame))
		{	if (verbose) perror("agent::receive recv() :");
			exit(12);
		}	
		
		FD_ZERO(&readfds);
		timeval	zero;
		zero.tv_sec=zero.tv_usec=0;
		ret=select(sd+1,&readfds,NULL,NULL,&zero);
		if (ret==-1)
		{	perror("agent::receive: select: ");
		}
	} while (FD_ISSET(sd,&readfds));
}	

packet_keys::packet_keys()
{	signature[0]='c';
	signature[1]='t';
	signature[2]='m';
	signature[3]='a';
	signature[4]='m';
	signature[5]='e';
	keys='@';
	ping=0;
}

void packet_keys::clear() 
{	keys='@';
}

void packet_keys::hyperspace(bool b)
{	if (b)
		keys|=KEY_HYPERSPACE;
	else
		keys&=~KEY_HYPERSPACE;
}

bool packet_keys::hyperspace()
{	return keys & KEY_HYPERSPACE;
}

void packet_keys::fire(bool b)
{	if (b)
		keys|=KEY_FIRE;
	else
		keys&=~KEY_FIRE;
}

void packet_keys::thrust(bool b)
{	if (b)
		keys|=KEY_THRUST;
	else
		keys&=~KEY_THRUST;
}

void packet_keys::left(bool b)
{	if (b)
		keys|=KEY_LEFT;
	else
		keys&=~KEY_LEFT;
}

void packet_keys::right(bool b)
{	if (b)
		keys|=KEY_RIGHT;
	else
		keys&=~KEY_RIGHT;
}

void packet_keys::start(bool b)
{	if (b)
		keys|=KEY_START;
	else
		keys&=~KEY_START;
}

