#include <string>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <unistd.h>
#include <fcntl.h>
#include <iostream>

#include "agent.h"

using namespace std;
int to_go=0;
bool contest_run=false;
bool dump=false;
bool auto_start=false;
bool verbose=false;

void usage(char *s)
{	cout << s << ": Usage:" << endl;
	cout << "	-h		this help screen" << endl;
	cout << "	-i ip-address" << endl;
	cout << " 	-g to_go" << endl;
	cout << "	-c contest run 18000 frames" << endl;
	cout << " or	" << s << " ip-address" << endl;
	cout << "	-d	vram loggin" << endl;
	cout << "	-v	verbose" << endl;
	cout << "	-a	do auto start" << endl;
	cout << endl;
}

int main(int argc,char **argv)
{	string	ip;
	unsigned long server_ip=INADDR_NONE;

	int k;
	while (-1!=(k=getopt(argc,argv,"i:ht:cdva")))
	{	switch (k)
		{	case 'h' :
				usage(argv[0]);
				return 0;
			case 'i' :
				ip=string(optarg);
				break;
			case 't' :
				to_go=atol(optarg);
				break;
			case 'c' :
				contest_run=true;
				break;
			case 'd' :
				dump=true;
				break;
			case 'v' :
				verbose=true;
				break;
			case 'a' :
				auto_start=true;
				break;
		}
	}	
	if (ip=="")
	{	// simulate original behavior
		if (argc!=2)
		{	cerr << "Aufruf: " << argv[0] << " <IP-Adresse>" << endl;
			return 1;
		}
		server_ip = inet_addr(argv[1]);
		if (server_ip==INADDR_NONE)
		{	cerr << "Ungueltige IP-Adresse: '" << argv[1] << "'" << endl;
			return 1;
		}
	}	
	if (server_ip==INADDR_NONE)
	{	server_ip = inet_addr(ip.c_str());
		if (server_ip==INADDR_NONE)
		{	cerr << "invalid ip" << endl;
			return 1;
		}
	}	

	int	sd;
	sd = socket(AF_INET, SOCK_DGRAM, 0);
	if (-1==sd)
	{	perror("error socket() :");
		return 2;
	}	
	if (-1==fcntl(sd,F_SETFL,O_NONBLOCK))
	{	perror("Kann Socket nicht auf non-blocking setzen");
		return 3;
	}	

	sockaddr_in sa;
	memset(&sa,0,sizeof(sa));
	sa.sin_family = AF_INET;
	sa.sin_addr.s_addr = 0;
	sa.sin_port = 0;

	if (bind(sd,(struct sockaddr*)&sa,sizeof(sa)))
	{	perror("error bind() :");
		return 4;
	}	

	agent	player(sd,server_ip);
	player.run();

	return 0;
}

