/* These routines calculate collisions */
/* $Id: aim.c,v 1.9 2008/05/18 14:13:20 raap Exp $ */

#include <stdio.h>
#include <math.h>
#include <stdlib.h>

#include "util.h"
#include "vector.h"
#include "player.h"
#include "objects.h"
#include "dir.h"
#include "aim.h"





/* The hit algorithm 
	We consider the target to start at start2 with direction dir2 and be a circle of radius r
	Our shot starts at start1 in direction dir1
	We simply assume that the target is not moving and adjust the speed of the shot accordingly
	Then we calculate the (0, 1, or 2) intersection points
	We return the time it takes the shot from the moment of its appearance to hit the target.
	The result is rounded up (!) to the nearest integer time value  
	If the result is 0, it means the shot appears right inside the target.
	If the result is -1, it means we cannot hit the target because it moves parallel to our shooting direction
	If the result is -2, it means we can only hit the target in the past.

 No wrap around
*/ 
int hit (koord *start1, delta *dir1, koord *start2, delta *dir2, int size){
	double  h, r, mu1, mu2;
	XY p1, p1p2, sc;

	/* P1 is the starting point of our shot */
	p1.x = start1->x;
	p1.y = start1->y;
	
	/* P1P2 is the corrected direction of our shot.*/
	p1p2.x = dir1->dx - dir2->dx; 
	p1p2.y = dir1->dy - dir2->dy;
	 	
	
	/* sc is the center of our target */
	sc.x = start2->x;
	sc.y = start2->y;
	
	/* r is radius of our target */
	r = size;
	
	if (RayCircle(p1, p1p2, sc, r, &mu1, &mu2)) {
		/* Now we have 1 or two intersection points 
			Make sure they are not behind our starting point 
		*/
		if ((mu1 < 0.0) && (mu2 < 0.0)) return (-2); 
		mu1 = fmax(mu1,0.0);
		mu2 = fmax(mu2,0.0);
		h = fmin(mu1,mu2);
//		printf("Hitting from (%d,%d) with <%d,%d> at (%d,%d) with <%d,%d> at time %.1f\n",
//			start1->x,start1->y, dir1->dx, dir1->dy, start2->x, start2->y, dir2->dx, dir2->dy, h); 
		return ((int) (h + 1.0));
	};
	return (-1);
};



/* The collision algorithm 
	Answers the question if ship will collide with given asteroid
	We consider the ship to be stationary. TODO if ship is moving, subtract its speed from asteroid
	We then take the minkowsky sum of the ship and the asteroid
	and assume the asteroid is only a point.
	We can then simply use the normal shooting algorithm to see if the asteroid hits the ship
	Returns first time of collision if asteroid (or other object) collides with ship 
	returns -1 otherwise
 No wrap around
*/
int collision (object *ast, object *ship){
	double h, r, mu1, mu2;
	XY p1, dp,  sc;


	/* r is minkowsky radius of ship and target */
	r = ast->size + ship->size;
	
	/* sc is the center of our target */
	sc.x = ship->cur_xy.x;
	sc.y = ship->cur_xy.y;
	
	/* P1 is the starting point of the asteroid */
	p1.x = ast->cur_xy.x;
	p1.y = ast->cur_xy.y;
	
	/* P2 is the direction of the asteroid */
	dp.x = ast->dir.dx; 
	dp.y = ast->dir.dy;	
	
	if (RayCircle(p1, dp, sc, r, &mu1, &mu2)) {
		/* Now we have 1 or two intersection points 
		Make sure they are not behind our starting point 
		*/
		if ((mu1 < 0) && (mu2 < 0)) return (-1); 
		mu1 = fmax(mu1,0.0);
		mu2 = fmax(mu2,0.0);
		h = fmin(mu1,mu2);
		
		return ((int) h + 0.5);
	};
	return (-1);
};

