/* $Id: frame.h,v 1.4 2008/05/08 23:08:40 raap Exp $ */

#ifndef FRAME_H
#define FRAME_H

#include "util.h"

#pragma pack(1)
typedef struct 
{
	char vectorram[1024];
	char frameno;  // wird bei jedem Frame inkrementiert
	char ping;     // Der Server schickt das letzte empfangene ping-Byte zurck
} FramePacket;
	

typedef struct 
{
	int x;    // Koordinaten des Mittelpunkts
	int y;
	int type; // 1 ... 4, uere Form
	int sf;   // scale factor: 0 = gro, 15 = mittel, 14 = klein
} Asteroid;

typedef struct 
{
	int x;    // Koordinaten des Mittelpunkts
	int y;
	int sf;   // scale factor: 0 = gro, 15 = mittel, 14 = klein
} Ufo;

typedef struct 
{
	int x;
	int y;
} Shot;

/* These numbers are way too high. Better safe than sorry! */
#define MAX_ASTEROIDS 100
#define MAX_SHOTS 30
#define MAX_UFOS 10

typedef struct 
{
	BOOL ship_present;  // Schiff sichtbar
	int ship_x;         // Mittelpunkt des Schiffs
	int ship_y;
	int ship_dx;        // Blickrichtung des Schiffes
	int ship_dy;
	BOOL saucer_present;// UFO sichtbar
	int saucer_x;       // Mittelpunkt des UFOs
	int saucer_y;
	int saucer_size;    // Gre: 15 = gro, 14 = klein
	int lives;	// number of lives
	Asteroid asteroids[MAX_ASTEROIDS];
	int nasteroids; // Anzahl Asteroiden
	Shot shots[MAX_SHOTS];
	int nshots;     // Anzahl Schsse
	Ufo ufos[MAX_UFOS];
	int nufos;
	int score;
} FrameStatus;

void 
InterpretScreen (FramePacket *packet, FrameStatus *frame);

#endif

