/* Utility functions needed by many routines */
/* $Id: util.c,v 1.2 2008/05/17 21:12:01 raap Exp $ */

#include "util.h"

// Read time stamp counter
// The return value is the internal clock count
__int64 ReadTSC() {
	int res[2];                              // store 64 bit result here
   
#if defined(__GNUC__) && !defined(__INTEL_COMPILER)
   // Inline assembly in AT&T syntax

#if defined (_LP64)                      // 64 bit mode
	__asm__ __volatile__  (               // serialize (save rbx)
					      "xorl %%eax,%%eax \n push %%rbx \n cpuid \n"
	::: "%rax", "%rcx", "%rdx");
	__asm__ __volatile__  (               // read TSC, store edx:eax in res
					      "rdtsc\n"
	: "=a" (res[0]), "=d" (res[1]) );
	__asm__ __volatile__  (               // serialize again
					      "xorl %%eax,%%eax \n cpuid \n pop %%rbx \n"
	::: "%rax", "%rcx", "%rdx");
#else                                    // 32 bit mode
	__asm__ __volatile__  (               // serialize (save ebx)
					      "xorl %%eax,%%eax \n pushl %%ebx \n cpuid \n"
	::: "%eax", "%ecx", "%edx");
	__asm__ __volatile__  (               // read TSC, store edx:eax in res
					      "rdtsc\n"
	: "=a" (res[0]), "=d" (res[1]) );
	__asm__ __volatile__  (               // serialize again
					      "xorl %%eax,%%eax \n cpuid \n popl %%ebx \n"
	::: "%eax", "%ecx", "%edx");
#endif
#else
   // Inline assembly in MASM syntax
	__asm {
		xor eax, eax
		cpuid                              // serialize
		rdtsc                              // read TSC
		mov dword ptr res, eax             // store low dword in res[0]
		mov dword ptr res+4, edx           // store high dword in res[1]
		xor eax, eax
		cpuid                              // serialize again
	};
#endif   // __GNUC__
   
	return *(__int64*)res;                   // return result
}

inline int min(int a, int b){
	return ((a < b) ? a : b);
};

inline int max(int a, int b){
	return ((a > b) ? a : b);
};

inline double fmin(double x, double y){
	return ( (x < y) ? x : y);
};

inline double fmax(double x, double y){
	return ( (x > y) ? x : y);
};


