// player.h: Beispielspieler fr Asteroids
// Harald Bgeholz / c't
/* Modified by HR */
/* $Id: player.h,v 1.5 2008/05/11 17:50:17 raap Exp $ */
#ifndef PLAYER_H
#define PLAYER_H

#if defined(WINDOWS)
#define ADDRESS DWORD
#else
#define SOCKET int
#define ADDRESS in_addr_t
// 3 Includes fr sockaddr_in
#include <sys/types.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#endif


#include "frame.h"
#include "util.h"
#include "objects.h"


void clear(void);
	
static const char KEY_HYPERSPACE = 1;
static const char KEY_FIRE = 2;
static const char KEY_THRUST = 4;
static const char KEY_RIGHT = 8;
static const char KEY_LEFT = 0x10;
static const char KEY_START = 0x20;
	

typedef struct
{
	char signature[6];
	char keys;
	char ping;     // wird vom Server bei nchster Gelegenheit zurckgeschickt. Fr Latenzmessung.


} KeysPacket;



void clear(void);         // alle Tasten loslassen
void hyperspace(BOOL b);  // Hyperspace drcken (true) oder loslassen (false)
void fire(BOOL b);        // Feuerknopf drcken (true) oder loslassen (false)
void thrust(BOOL b);      // Beschleunigen ...
void right(BOOL b);       // rechts drehen ...
void left(BOOL b);        // links drehen


#pragma pack()
	
typedef struct {
	SOCKET sock;
	ADDRESS server_ip;
} Player;


void Run(Player *p);

void InterpretScreen(FramePacket *packet, FrameStatus *frame);
int ReceivePacket(Player *p, FramePacket *packet);
void SendPacket(Player *p, KeysPacket *packet);
void key_right(KeysPacket *kp, BOOL b);
void key_left(KeysPacket *kp, BOOL b);
void key_thrust(KeysPacket *kp, BOOL b);
void key_fire(KeysPacket *kp, BOOL b);
void key_hyperspace(KeysPacket *kp, BOOL b);
void key_start(KeysPacket *kp, BOOL b);
void keys_clear(KeysPacket *kp);
void init_keys(KeysPacket *kp);


void prt_time();

#endif


