/* Definitions for vector.c */
/* $Id: vector.h,v 1.7 2008/05/17 21:12:01 raap Exp $ */

#ifndef VECTOR_H
#define VECTOR_H

#include "util.h"

/* Two dimensional vector or point (floating point precision) */
typedef struct {
	double x,y;
} XY;

/* Three dimensional vector or point (floating point precision) */
typedef struct {
	double x,y,z;
} XYZ;

/* Function prototypes */
double LineLength2D (XY p1, XY p2);
double VectorLength2D (XY p1);
int LineIntersect2D( XY p1, XY p1p2, XY p3, XY p3p4, double *mua, double *mub);


/* An (x,y) position in the game coordinate system (0..1023, 0..767) 
	Can really be outside of these bounds
*/
typedef struct{
	int	x;
	int	y;
} koord;


/* An integer direction vector. dx and dy may be positive or negative and any size */
typedef struct{
	int	dx;
	int	dy;
} delta;

int is_null(delta *d);
int length(delta *d);
void koord_check(koord *k, char *s);
void add_dir_wrap( koord *k, delta *d, koord *newk);
void sto_dir(koord *k1, koord *k2, delta *res);
int dot_prod(delta *d1, delta *d2);
int cross_prod_z(delta *d1, delta *d2);
double angle (delta *d);
int sign(double x);
void ext2int (int x, int y, koord *k);
void ext2int_dir (int x, int y, delta *d);
int dist_wrap(koord *k1, koord *k2, delta *delta_res);
BOOL RaySphere(XYZ p1, XYZ p2, XYZ sc, double r, double *mu1, double *mu2);
BOOL RayCircle(XY p1, XY dp, XY sc, double r, double *mu1, double *mu2);
void create_shadows(koord *k2, koord k[]);
double angle_double (double x, double y);
int dir_turn (delta *d1, delta *d2);
int dir_diff_XY (XY d1, XY d2);
int dist_delta(koord *k1, koord *k2, delta *delta_res);
double dir_diff_double (XY d1, XY d2);

#endif

