/*
 * Decompiled with CFR 0.152.
 */
package asteroid;

import asteroid.SimpleLogging;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;

public class PrintWriterFormat
extends PrintWriter
implements Runnable {
    private int mLinePos;
    private int mSavePos;

    public PrintWriterFormat(String string) {
        super(PrintWriterFormat.createFileWriter(string), true);
        Runtime.getRuntime().addShutdownHook(new Thread(this));
    }

    public PrintWriterFormat(OutputStream outputStream) {
        super(outputStream, true);
    }

    public PrintWriterFormat(Writer writer) {
        super(writer, true);
    }

    private static PrintStream createFileWriter(String string) {
        try {
            return new PrintStream(new BufferedOutputStream(new FileOutputStream(string)), true);
        }
        catch (IOException iOException) {
            SimpleLogging.addException(iOException);
            return System.out;
        }
    }

    public void fill(int n) {
        this.mSavePos += n;
        while (this.mLinePos < this.mSavePos) {
            this.write(32);
        }
    }

    private void movePos(int n) {
        if (n == 10) {
            this.mSavePos -= this.mLinePos;
            this.mLinePos = 0;
        } else {
            ++this.mLinePos;
        }
    }

    public int getPos() {
        return this.mLinePos;
    }

    public void printByte(int n) {
        if ((n &= 0xFF) < 10) {
            this.print("00" + String.valueOf(n));
        } else if (n < 100) {
            this.print("0" + String.valueOf(n));
        } else {
            this.print(String.valueOf(n));
        }
    }

    public void printKey(int n) {
        this.print((n & 1) != 0 ? (char)'H' : '_');
        this.print((n & 2) != 0 ? (char)'F' : '_');
        this.print((n & 4) != 0 ? (char)'T' : '_');
        this.print((n & 8) != 0 ? (char)'R' : '_');
        this.print((n & 0x10) != 0 ? (char)'L' : '_');
        this.print((n & 0x20) != 0 ? (char)'S' : '_');
    }

    public void println() {
        super.println();
        this.mLinePos = 0;
    }

    public void printPos(int n) {
        if (n < 10) {
            this.print("000" + String.valueOf(n));
        } else if (n < 100) {
            this.print("00" + String.valueOf(n));
        } else if (n < 1000) {
            this.print("0" + String.valueOf(n));
        } else {
            this.print(String.valueOf(n));
        }
    }

    public void printSign(int n) {
        this.print(n < 0 ? (char)'-' : '+');
        this.printZoom(Math.abs(n));
    }

    public void printZoom(int n) {
        if (n < 10) {
            this.print("0" + String.valueOf(n));
        } else {
            this.print(String.valueOf(n));
        }
    }

    public void run() {
        try {
            this.flush();
            this.close();
        }
        catch (Exception exception) {
            System.err.println("Unerwartete Exception: " + exception.getMessage());
        }
    }

    public void savePos() {
        this.mSavePos = this.mLinePos;
    }

    public void write(int n) {
        super.write(n);
        this.movePos(n);
    }

    public void write(String string, int n, int n2) {
        super.write(string, n, n2);
        for (int i = 0; i < n2; ++i) {
            this.movePos(string.charAt(n + i));
        }
    }

    public void write(char[] cArray, int n, int n2) {
        super.write(cArray, n, n2);
        for (int i = 0; i < n2; ++i) {
            this.movePos(cArray[n + i]);
        }
    }
}

