/*
 * Decompiled with CFR 0.152.
 */
package asteroid.model;

import asteroid.Player;
import asteroid.SimpleLogging;
import asteroid.model.AEnemy;
import asteroid.model.Angle;
import asteroid.model.AsteroidVector;
import asteroid.model.Collider;
import asteroid.model.Detector;
import asteroid.model.FlyInfo;
import asteroid.model.ICompute;
import asteroid.model.Ship;
import asteroid.model.ShotVector;
import asteroid.model.Striker;
import asteroid.model.Ufo;
import asteroid.printer.Source;
import asteroid.strategy.AStrategie;
import asteroid.udp.AHandler;
import java.nio.ByteBuffer;
import java.util.StringTokenizer;

public class GameModel {
    public static final int FRAME_TYPE_READY = 1;
    public static final int FRAME_TYPE_HIGH = 2;
    public static final int FRAME_TYPE_START = 3;
    public static final int FRAME_TYPE_GAME = 4;
    public static final int FRAME_TYPE_GAME_OVER = 5;
    public static final int FRAME_TYPE_END = 6;
    public static final int FRAME_TYPE_SCORE = 7;
    private static final String USER_SIGN = "GRA";
    private static final int KEY_HOLD_TIME = 10;
    public static int sFrame;
    public static int sFrameOffset;
    public static int sFrameID;
    Ship mShip = new Ship();
    Ufo mUfo = new Ufo(this.mShip);
    AsteroidVector mAsts = new AsteroidVector(this.mShip, this.mUfo);
    ShotVector mShots = new ShotVector(this.mShip, this.mUfo);
    Collider mCollider = new Collider(this.mShip, this.mUfo, this.mAsts, this.mShots);
    Detector mDetector = new Detector(this.mShip, this.mUfo, this.mAsts, this.mShots);
    Striker mStriker = new Striker(this.mShip, this.mUfo, this.mAsts, this.mShots);
    private Angle mAngle = new Angle(this.mShip);
    private boolean mAutoStart;
    private int mFrameType = 4;
    private int mRelease;
    private boolean mRepeat = false;
    private Source mSource;
    private AHandler mSrc;
    private boolean mTopList = false;

    public GameModel(AHandler aHandler) {
        this.mSrc = aHandler;
    }

    public void addKey(int n) {
        this.mCollider.detect(Angle.sForward);
        this.mSrc.addKey(this.mAngle.getKey(n | this.mCollider.getKey()));
    }

    public void setAutoStart() {
        this.mAutoStart = true;
    }

    public boolean isAutoStart() {
        return this.mAutoStart || this.mRepeat;
    }

    public AEnemy getEnemy(int n) {
        if (n == 27) {
            return this.mUfo;
        }
        return this.mAsts.get(n);
    }

    public int getFireDirection() {
        return this.mAngle.getFireDirection();
    }

    public void forAllAsteroids(ICompute iCompute) {
        this.mAsts.forAll(iCompute);
    }

    public void forAllDetectAsteroids(ICompute iCompute) {
        this.mAsts.forAllDetect(iCompute);
    }

    public void forAllDetectShots(ICompute iCompute) {
        this.mShots.forAllDetect(iCompute);
    }

    public void forAllShots(ICompute iCompute) {
        this.mShots.forAll(iCompute);
    }

    public void forShip(ICompute iCompute) {
        this.mShip.doIt(iCompute);
    }

    public void forUfo(ICompute iCompute) {
        this.mUfo.doIt(iCompute);
    }

    public int getFrameType() {
        return this.mFrameType;
    }

    public int getHighScore() {
        return this.mDetector.mHighScore;
    }

    public int getHits() {
        return this.mStriker.mStrikes;
    }

    public void interpret(ByteBuffer byteBuffer) {
        GameModel.syncFrame(byteBuffer.get(1024) & 0xFF);
        if (sFrame >= 550) {
            sFrame += 0;
        }
        int n = this.mDetector.mScore;
        this.mDetector.prepare();
        this.mDetector.interpret(byteBuffer);
        this.mDetector.detect(this.mAngle.getFireDirection());
        this.mFrameType = this.mDetector.mFrameType;
        this.mStriker.detect();
        if (this.mStriker.mScore != n && this.isPlayTime()) {
            if (this.mStriker.mScore > 0) {
                SimpleLogging.addLog("missing stikes " + n + "!=" + this.mStriker.mScore);
            }
            this.mStriker.mScore = n;
        }
        this.syncType();
        this.mAngle.synchronice(byteBuffer.get(1025) & 0xFF);
        if (this.mSource != null) {
            this.mSource.print(byteBuffer);
        }
    }

    public int getLevel() {
        return this.mDetector.mLevel;
    }

    public int getLives() {
        return this.mDetector.mLives;
    }

    public void move(int n) {
        Angle.sDirection += 3 * n;
        this.mAngle.initDirection();
        int n2 = Math.abs(n);
        for (int i = 0; i <= 27; ++i) {
            this.getEnemy(i).move(n2);
        }
    }

    public int getOtherScore() {
        return this.mDetector.mOtherScore;
    }

    public void parse(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        String string2 = stringTokenizer.nextToken();
        StringTokenizer stringTokenizer2 = new StringTokenizer(string2, ",");
        sFrame = GameModel.parseInt(stringTokenizer2.nextToken().trim());
        stringTokenizer2.nextToken();
        Angle.sReceivePing = GameModel.parseInt(stringTokenizer2.nextToken().trim());
        Angle.sSendPing = GameModel.parseInt(stringTokenizer2.nextToken().trim());
        Angle.sDirection = GameModel.parseInt(stringTokenizer2.nextToken().trim());
        Angle.sForward = GameModel.parseInt(stringTokenizer2.nextToken().trim());
        this.mAngle.initDirection();
        while (stringTokenizer.hasMoreTokens()) {
            int n;
            String string3 = stringTokenizer.nextToken();
            StringTokenizer stringTokenizer3 = new StringTokenizer(string3, ":,");
            String string4 = stringTokenizer3.nextToken();
            int n2 = GameModel.parseInt(stringTokenizer3.nextToken().trim());
            int n3 = GameModel.parseInt(stringTokenizer3.nextToken().trim());
            int n4 = GameModel.parseInt(stringTokenizer3.nextToken().trim());
            int n5 = GameModel.parseInt(stringTokenizer3.nextToken().trim());
            int n6 = GameModel.parseInt(stringTokenizer3.nextToken().trim());
            if ("S".equals(string4)) {
                this.mShip.set(n2, n3, n4, n5, n6, 1);
                continue;
            }
            if ("T".equals(string4)) {
                this.mShip.set(n2, n3, n4, n5, n6, 2);
                continue;
            }
            if ("J".equals(string4)) {
                this.mShip.set(n2, n3, n4, n5, n6, 4);
                continue;
            }
            if ("s".equals(string4)) {
                this.mShip.set(n2, n3, n4, n5, n6, 0);
                continue;
            }
            if ("U".equals(string4)) {
                this.mUfo.set(n2, n3, n4, n5, n6, 1);
                continue;
            }
            if ("X".equals(string4)) {
                this.mUfo.set(n2, n3, n4, n5, n6, 2);
                continue;
            }
            if ("u".equals(string4)) {
                this.mUfo.set(n2, n3, n4, n5, n6, 0);
                continue;
            }
            if (string4.startsWith("A")) {
                n = GameModel.parseInt(string4.substring(1));
                this.mAsts.set(n, n2, n3, n4, n5, n6, 1);
                continue;
            }
            if (string4.startsWith("E")) {
                n = GameModel.parseInt(string4.substring(1));
                this.mAsts.set(n, n2, n3, n4, n5, n6, 2);
                continue;
            }
            if (string4.startsWith("a")) {
                n = GameModel.parseInt(string4.substring(1));
                this.mAsts.set(n, n2, n3, n4, n5, n6, 0);
                continue;
            }
            if (string4.startsWith("e")) {
                n = GameModel.parseInt(string4.substring(1));
                this.mAsts.set(n, n2, n3, n4, n5, n6, 3);
                continue;
            }
            if (string4.startsWith("M")) {
                n = GameModel.parseInt(string4.substring(1));
                this.mShots.set(n, n2, n3, n4, n5, n6, 1);
                continue;
            }
            if (string4.startsWith("_")) {
                n = GameModel.parseInt(string4.substring(1));
                this.mShots.set(n, n2, n3, n4, n5, n6, 0);
                continue;
            }
            throw new IllegalArgumentException("missing type: " + string3);
        }
    }

    private static int parseInt(String string) {
        int n = 1;
        if (string.startsWith("+")) {
            string = string.substring(1);
        }
        if (string.startsWith("-")) {
            string = string.substring(1);
            n = -1;
        }
        while (string.startsWith("0")) {
            string = string.substring(1);
        }
        if (string.length() == 0) {
            return 0;
        }
        return n * Integer.parseInt(string);
    }

    public int getPlayFrame() {
        return this.mDetector.mPlayFrame;
    }

    public boolean isPlayTime() {
        return this.mFrameType == 4;
    }

    public void setRepeat(boolean bl) {
        this.mRepeat = bl;
    }

    public int getScore() {
        return this.mDetector.mScore;
    }

    public String getScore(int n) {
        return this.mDetector.mHighScores.mValues[n];
    }

    public Ship getShip() {
        return this.mShip;
    }

    public boolean isShipVisible() {
        return this.mShip.isVisible();
    }

    public FlyInfo getShot(int n) {
        return this.mShots.get(n);
    }

    public int getShots() {
        return this.mStriker.mCreates;
    }

    private static void syncFrame(int n) {
        int n2 = sFrame & 0xFF;
        if (n < n2) {
            n2 -= 256;
        }
        sFrame -= (n2 -= n);
    }

    private void syncType() {
        switch (this.mFrameType) {
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                this.mAsts.clearAll();
                this.mShots.clearAll();
                this.mDetector.reset();
                this.mStriker.reset();
                this.mAutoStart = false;
                break;
            }
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                break;
            }
        }
    }

    public void setTopList(boolean bl) {
        this.mTopList = bl;
    }

    public boolean isTopList() {
        return this.mTopList;
    }

    public Ufo getUfo() {
        return this.mUfo;
    }

    public void updateKey(AStrategie aStrategie) {
        int n = 0;
        switch (this.mFrameType) {
            case 1: 
            case 2: {
                if (this.isAutoStart()) {
                    n = 32;
                }
                this.mRelease = 10;
                break;
            }
            case 3: {
                if (Player.sHost != 2 || this.mRelease <= 0) break;
                n = 65535;
                --this.mRelease;
                break;
            }
            case 4: {
                n = aStrategie.getKey();
                break;
            }
            case 5: {
                n = (sFrame & 4) != 0 ? 1 : 0;
                break;
            }
            case 6: {
                this.mRelease = 0;
                break;
            }
            case 7: {
                n = this.userScore();
            }
        }
        this.addKey(n);
        this.mDetector.setPlayTime();
    }

    private int userScore() {
        if (this.mRelease > 0) {
            return this.mRelease-- > 10 ? 1 : 0;
        }
        String string = this.mDetector.mSign;
        int n = string.length() - 1;
        int n2 = string.charAt(n) - USER_SIGN.charAt(n);
        if (this.isTopList() && n2 != 0) {
            return n2 > 0 ? 8 : 16;
        }
        this.mRelease = 20;
        return 1;
    }

    public boolean isVanished() {
        return this.mStriker.mVanish > 0;
    }
}

