/*
 * Decompiled with CFR 0.152.
 */
package asteroid.model;

import asteroid.model.ACompute;
import asteroid.model.AEnemy;
import asteroid.model.Angle;
import asteroid.model.Asteroid;
import asteroid.model.GameModel;
import asteroid.model.Shot;
import asteroid.model.Ufo;

public class Magazine
extends ACompute {
    private int mFire;
    private int mShots;
    private int mFireDirection;
    private int mMaxTimeWait = Angle.sForward << 2;
    private int[] mPivot = new int[4];
    private Target[] mTargets = new Target[4];

    public Magazine() {
        for (int i = 0; i < 4; ++i) {
            this.mTargets[i] = new Target();
            this.mPivot[i] = -1;
        }
    }

    public boolean addFire(AEnemy aEnemy) {
        for (int i = 0; i < 4; ++i) {
            Target target = this.mTargets[i];
            if (target.mShot != null || target.mEnemy != null) continue;
            aEnemy.decFire();
            target.mEnemy = aEnemy;
            target.mTimeOut = this.mMaxTimeWait;
            this.mFire = 1;
            return true;
        }
        return false;
    }

    public void addFire(AEnemy aEnemy, boolean bl) {
        if (this.mFire == 0 && (bl || !this.isTaget(aEnemy))) {
            this.addFire(aEnemy);
        }
    }

    public boolean canFire() {
        return this.mFire == 0;
    }

    public void cleanup(GameModel gameModel) {
        this.mMaxTimeWait = Angle.sForward << 2;
        this.mFireDirection = gameModel.getFireDirection();
        this.mShots = 0;
        gameModel.forUfo(this);
        gameModel.forAllAsteroids(this);
        gameModel.forAllShots(this);
    }

    private void clearShot(Target target) {
        if (target.mShot != null) {
            this.mPivot[target.mShot.getIndex()] = -1;
        }
        target.mShot = null;
    }

    public boolean isFire() {
        return this.mFire == 1;
    }

    public void forAsteroid(Asteroid asteroid) {
        this.forEnemy(asteroid);
    }

    private void forEnemy(AEnemy aEnemy) {
        boolean bl = true;
        for (int i = 0; i < 4; ++i) {
            Target target = this.mTargets[i];
            if (target.mEnemy != aEnemy) continue;
            bl = false;
            if (!aEnemy.isVisible()) {
                aEnemy.initFire();
                target.mEnemy = null;
            } else if (target.mShot == null && target.mTimeOut > 0) {
                --target.mTimeOut;
            }
            if (target.mTimeOut > 0) continue;
            aEnemy.initFire();
            target.mEnemy = null;
        }
        if (bl && aEnemy.isVisible()) {
            aEnemy.initFire();
        }
    }

    public void forShot(Shot shot) {
        if (shot.isShip()) {
            Target target;
            int n;
            if (shot.getVanish() > 0 || shot.isHidden()) {
                n = this.mPivot[shot.getIndex()];
                if (n >= 0) {
                    target = this.mTargets[n];
                    if (target.mEnemy != null) {
                        target.mEnemy.initFire();
                        target.mEnemy = null;
                    }
                    this.clearShot(target);
                    this.moveTarget(target, n + 1);
                }
                shot.mHitTime = 2.147483647E9;
            }
            if (shot.getCreate() > 0) {
                for (n = 0; n < 4; ++n) {
                    target = this.mTargets[n];
                    if (target.mShot != null) continue;
                    this.setShot(target, shot, n);
                    target.mDirection = this.mFireDirection;
                    break;
                }
            }
            if (shot.isVisible()) {
                ++this.mShots;
            }
        }
    }

    public void forUfo(Ufo ufo) {
        this.forEnemy(ufo);
    }

    public static double hitTime(Shot shot, AEnemy aEnemy) {
        int n = shot.mMoveX8 * aEnemy.mMoveY8 - shot.mMoveY8 * aEnemy.mMoveX8;
        if (n == 0) {
            return 2.147483647E9;
        }
        double d = (aEnemy.mX8 - shot.mX8) * aEnemy.mMoveY8 - (aEnemy.mY8 - shot.mY8) * aEnemy.mMoveX8;
        return d / (double)n;
    }

    public static double hitTime2(Shot shot, AEnemy aEnemy) {
        double d;
        int n = aEnemy.mMoveX8 - shot.mMoveX8;
        int n2 = aEnemy.mMoveY8 - shot.mMoveY8;
        int n3 = n * n + n2 * n2;
        if (n3 == 0) {
            return 2.147483647E9;
        }
        double d2 = aEnemy.sizeX() * aEnemy.sizeY() * n3;
        int n4 = aEnemy.mX8 - shot.mX8;
        int n5 = aEnemy.mY8 - shot.mY8;
        int n6 = n4 * n2 - n5 * n;
        double d3 = n6 * n6;
        if ((d2 -= d3) < 0.0) {
            return 2.147483647E9;
        }
        double d4 = n4 * n + n5 * n2;
        double d5 = Math.sqrt(d2);
        double d6 = -d4 - d5;
        if (d6 < (d = -d4 + d5)) {
            return d6 / (double)n3;
        }
        return d / (double)n3;
    }

    public int getKey() {
        return this.mFire == 1 ? 2 : 0;
    }

    private void moveTarget(Target target, int n) {
        for (int i = n; i < 4; ++i) {
            this.setTarget(i - 1, this.mTargets[i]);
        }
        this.setTarget(3, target);
    }

    public void prepareFire() {
        this.mFire = this.mFire << 1 & 3;
    }

    void preView(Shot shot) {
        int n = this.mPivot[shot.getIndex()];
        if (n >= 0) {
            Target target = this.mTargets[n];
            if (target.mEnemy != null) {
                shot.mHitTime = Magazine.hitTime2(shot, target.mEnemy);
                if (shot.mHitTime <= (double)Angle.sForward) {
                    target.mEnemy.decFire();
                    target.mEnemy.decFire();
                    target.mEnemy = null;
                    this.clearShot(target);
                    this.moveTarget(target, n + 1);
                }
            }
        }
    }

    private void setShot(Target target, Shot shot, int n) {
        target.mShot = shot;
        this.mPivot[shot.getIndex()] = n;
    }

    public int getShots() {
        return this.mShots;
    }

    public boolean isTaget(AEnemy aEnemy) {
        for (int i = 0; i < 4; ++i) {
            if (this.mTargets[i].mEnemy != aEnemy) continue;
            return true;
        }
        return false;
    }

    private void setTarget(int n, Target target) {
        this.mTargets[n] = target;
        if (target.mShot != null) {
            this.mPivot[target.mShot.getIndex()] = n;
        }
    }

    private static class Target {
        int mDirection;
        AEnemy mEnemy;
        Shot mShot;
        int mTimeOut;

        private Target() {
        }
    }
}

