/*
 * Decompiled with CFR 0.152.
 */
package asteroid.model;

import asteroid.Operation;
import asteroid.SimpleLogging;
import asteroid.model.ACompute;
import asteroid.model.Asteroid;
import asteroid.model.AsteroidVector;
import asteroid.model.Ship;
import asteroid.model.Shot;
import asteroid.model.ShotVector;
import asteroid.model.Ufo;

public class Striker
extends ACompute {
    private static final int MIN_HIT_DIST = 80;
    int mCreates;
    int mScore;
    int mStrikes;
    int mVanish;
    private AsteroidVector mAsts;
    private Ship mShip;
    private ShotVector mShots;
    private Ufo mUfo;

    Striker(Ship ship, Ufo ufo, AsteroidVector asteroidVector, ShotVector shotVector) {
        this.mShip = ship;
        this.mUfo = ufo;
        this.mAsts = asteroidVector;
        this.mShots = shotVector;
    }

    void detect() {
        this.mVanish = this.mShots.getVanish();
        if (this.mAsts.getVanish() > 0) {
            this.mAsts.forAll(this);
            this.mVanish += this.mAsts.getVanish();
        }
        if (this.mShip.getVanish() == 1) {
            this.mShip.doIt(this);
            ++this.mVanish;
        }
        if (this.mUfo.getVanish() == 1) {
            this.mUfo.doIt(this);
            ++this.mVanish;
        }
        this.mShots.forAll(this);
        if (this.mShip.mVanish == 1) {
            this.mShip.mState = 4;
        }
    }

    public void forAsteroid(Asteroid asteroid) {
        if (asteroid.mVanish == 1 && this.mUfo.mVanish == 1 && Striker.isHitAsteroidUfo(asteroid, this.mUfo)) {
            asteroid.mVanish |= 2;
            this.mUfo.mVanish |= 2;
        }
        if (asteroid.mVanish == 1 && this.mShip.mVanish == 1 && Striker.isHitAsteroidShip(asteroid, this.mShip)) {
            asteroid.mVanish |= 2;
            this.mShip.mVanish |= 2;
            this.mScore += asteroid.getScore();
        }
        for (int i = 0; i < 6; ++i) {
            Shot shot = this.mShots.mShots[i];
            if (asteroid.mVanish != 1 || shot.mVanish != 1 || !Striker.isHitAsteroidShot(asteroid, shot)) continue;
            asteroid.mVanish |= 2;
            shot.mVanish |= 2;
            if (!shot.isShip()) continue;
            ++this.mStrikes;
            this.mScore += asteroid.getScore();
        }
    }

    public void forShip(Ship ship) {
        if (ship.mVanish == 1 && this.mUfo.mVanish == 1 && Striker.isHitShipUfo(ship, this.mUfo)) {
            ship.mVanish |= 2;
            this.mUfo.mVanish |= 2;
        }
        for (int i = 0; i < 6; ++i) {
            Shot shot = this.mShots.mShots[i];
            if (ship.mVanish != 1 || shot.mVanish != 1 || !Striker.isHitShipShot(ship, shot)) continue;
            ship.mVanish |= 2;
            shot.mVanish |= 2;
            if (!shot.isShip()) continue;
            SimpleLogging.addLog("oh nein, Selbstmord");
        }
    }

    public void forShot(Shot shot) {
        if (shot.mCreate == 1) {
            shot.mCreate |= 2;
            if (shot.isShip()) {
                ++this.mCreates;
            }
        }
    }

    public void forUfo(Ufo ufo) {
        for (int i = 0; i < 6; ++i) {
            Shot shot = this.mShots.mShots[i];
            if (ufo.mVanish != 1 || shot.mVanish != 1 || !Striker.isHitUfoShot(ufo, shot)) continue;
            ufo.mVanish |= 2;
            shot.mVanish |= 2;
            if (!shot.isShip()) continue;
            ++this.mStrikes;
            this.mScore += ufo.getScore();
        }
    }

    public static boolean isHitAsteroidShip(Asteroid asteroid, Ship ship) {
        int n = Operation.distX8(asteroid.mX8 - ship.mX8);
        int n2 = Operation.distY8(asteroid.mY8 - ship.mY8);
        n -= asteroid.sizeX();
        n2 -= asteroid.sizeY();
        return (n -= ship.sizeX()) < 80 && (n2 -= ship.sizeY()) < 80;
    }

    public static boolean isHitAsteroidShot(Asteroid asteroid, Shot shot) {
        int n = Operation.distX8(asteroid.mX8 - shot.mLast.mX8);
        int n2 = Operation.distY8(asteroid.mY8 - shot.mLast.mY8);
        n -= asteroid.sizeX();
        n2 -= asteroid.sizeY();
        return (n -= shot.sizeX()) < 80 && (n2 -= shot.sizeY()) < 80;
    }

    public static boolean isHitAsteroidUfo(Asteroid asteroid, Ufo ufo) {
        int n = Operation.distX8(asteroid.mX8 - ufo.mX8);
        int n2 = Operation.distY8(asteroid.mY8 - ufo.mY8);
        n -= asteroid.sizeX();
        n2 -= asteroid.sizeY();
        return (n -= ufo.sizeX()) < 80 && (n2 -= ufo.sizeY()) < 80;
    }

    public static boolean isHitShipShot(Ship ship, Shot shot) {
        int n = Operation.distX8(ship.mX8 - shot.mLast.mX8);
        int n2 = Operation.distY8(ship.mY8 - shot.mLast.mY8);
        n -= ship.sizeX();
        n2 -= ship.sizeY();
        return (n -= shot.sizeX()) < 80 && (n2 -= shot.sizeY()) < 80;
    }

    public static boolean isHitShipUfo(Ship ship, Ufo ufo) {
        int n = Operation.distX8(ship.mX8 - ufo.mX8);
        int n2 = Operation.distY8(ship.mY8 - ufo.mY8);
        n -= ship.sizeX();
        n2 -= ship.sizeY();
        return (n -= ufo.sizeX()) < 80 && (n2 -= ufo.sizeY()) < 80;
    }

    public static boolean isHitUfoShot(Ufo ufo, Shot shot) {
        int n = Operation.distX8(ufo.mX8 - shot.mLast.mX8);
        int n2 = Operation.distY8(ufo.mY8 - shot.mLast.mY8);
        n -= ufo.sizeX();
        n2 -= ufo.sizeY();
        return (n -= shot.sizeX()) < 80 && (n2 -= shot.sizeY()) < 80;
    }

    public void reset() {
        this.mScore = 0;
        this.mCreates = 0;
        this.mStrikes = 0;
    }
}

